/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging.appender;

import java.io.File;
import org.zhiqim.kernel.logging.appender.FileAppender;
import org.zhiqim.kernel.util.DateTimes;

public class FileDailyAppender
extends FileAppender {
    private final Object lock = new Object();
    private volatile String fileDate;

    @Override
    public void append(int level, String message, Throwable throwable) {
        String curDate = DateTimes.getDateString();
        if (!curDate.equals(this.fileDate)) {
            this.convertWriter(curDate);
        }
        this.print(level, message, throwable);
    }

    @Override
    public void setFilePath(String filePath) {
        super.setFilePath(filePath);
        this.convertWriter(DateTimes.getDateString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertWriter(String date) {
        Object object = this.lock;
        synchronized (object) {
            if (date.equals(this.fileDate)) {
                return;
            }
            super.closeWriter();
            super.setFilePathOnly(this.newFilePath(date));
            super.createWriter();
            this.removeMaxFile();
            this.fileDate = date;
        }
    }

    private void removeMaxFile() {
        if (this.fileMaxNum <= 0) {
            return;
        }
        String maxIndexDate = DateTimes.getPreviousDateString(this.fileMaxNum);
        File dir = new File(this.fileDir);
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String date;
            File file = fileArray[n2];
            if (file.isFile() && file.getName().length() >= 10 && file.getName().endsWith("." + this.fileName) && (date = file.getName().substring(0, 10)).compareTo(maxIndexDate) < 0) {
                file.delete();
            }
            ++n2;
        }
    }

    private String newFilePath(String date) {
        return this.fileDir + "/" + date + "." + this.fileName;
    }
}

