/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging.appender;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.logging.LogAppender;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Stringx;

public abstract class FileAppender
implements LogAppender,
CodeConstants {
    protected String filePattern;
    protected String filePath;
    protected int fileMaxNum;
    protected int fileMaxSize;
    protected String fileEncoding = "UTF-8";
    protected PrintWriter writer;
    protected String fileDir;
    protected String fileName;

    protected void print(int level, String message, Throwable throwable) {
        if (message != null) {
            message = LogFactory.format(this.filePattern, message, LogFactory.getLevel(level));
            this.writer.print(message);
            this.writer.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(this.writer);
        }
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    protected void closeWriter() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    protected void createWriter() {
        block4: {
            try {
                String fileDir = Files.getFileDirPath(this.filePath);
                if (!Files.isDirectory(fileDir)) {
                    Files.mkDirectory(fileDir);
                }
                File file = new File(this.filePath);
                boolean exists = file.exists();
                FileOutputStream os = new FileOutputStream(this.filePath, true);
                if (!exists && "UTF-8".equals(this.fileEncoding)) {
                    ((OutputStream)os).write(239);
                    ((OutputStream)os).write(187);
                    ((OutputStream)os).write(191);
                    os.flush();
                }
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, this.fileEncoding);
                this.writer = new PrintWriter((Writer)osw, true);
            }
            catch (IOException e) {
                if (!(e instanceof InterruptedIOException)) break block4;
                Thread.currentThread().interrupt();
            }
        }
    }

    protected long getFileSize() {
        File file = new File(this.filePath);
        if (!Files.isFile(file)) {
            return 0L;
        }
        return file.length();
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = Stringx.trim(filePattern);
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = Stringx.trim(filePath);
        this.fileDir = Files.toLinuxPath(Files.getFileDirPath(this.filePath));
        this.fileName = Files.getFileName(this.filePath);
    }

    public void setFilePathOnly(String filePath) {
        this.filePath = filePath;
    }

    public int getFileMaxNum() {
        return this.fileMaxNum;
    }

    public void setFileMaxNum(int fileMaxNum) {
        this.fileMaxNum = fileMaxNum;
    }

    public int getFileMaxSize() {
        return this.fileMaxSize;
    }

    public void setFileMaxSize(int fileMaxSize) {
        this.fileMaxSize = fileMaxSize * 1024 * 1024;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = Strings.trim(fileEncoding, "UTF-8");
    }
}

