/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging;

import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Servicer;
import org.zhiqim.kernel.annotation.AnNullable;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogConfig;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.logging.LogService;
import org.zhiqim.kernel.logging.LoggerWapper;
import org.zhiqim.kernel.logging.appender.ConsoleAppender;
import org.zhiqim.kernel.logging.appender.FileAppender;
import org.zhiqim.kernel.logging.appender.FileDailyAppender;
import org.zhiqim.kernel.logging.logger.ZhiqimLogger;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class LogServer
extends Servicer
implements LogService {
    private static final HashMapSV<LoggerWapper> mustNameMap = new HashMapSV();
    private static final HashMapCV<LoggerWapper> mustClassMap = new HashMapCV();
    private static final LoggerWapper defaultWapper = new LoggerWapper();

    @Override
    public boolean create() throws Exception {
        if (!Global.hasGroup(this.id)) {
            System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + this.id + "]\u4e0d\u5b58\u5728");
            return false;
        }
        for (Item item : Global.getGroup(this.id).list()) {
            LoggerWapper map;
            String key = item.getKey();
            if (!Global.hasGroup(key)) {
                System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + key + "]\u4e0d\u5b58\u5728");
                return false;
            }
            String value = item.getString();
            if (Validates.isEmpty(value) || value.indexOf("-") == -1) {
                System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + key + "]\u7684value(\u7ea7\u522b)\u4e0d\u6b63\u786e\uff0c\u683c\u5f0f\u5982debug-info");
                return false;
            }
            String[] levels = Arrays.toStringArray(value, "-");
            int levelMin = LogFactory.getLevel(levels[0]);
            int levelMax = LogFactory.getLevel(levels[1]);
            if (levelMin == 0 || levelMax == 0 || levelMax < levelMin) {
                System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + key + "]\u7ea7\u522b\u914d\u7f6e\u6709\u8bef\uff0c\u6700\u5c0f\u548c\u6700\u5927\u503c\u5fc5\u987b\u5728(debug|info|error|warn|fatal)\u8303\u56f4\u5185\uff0c\u5982error-fatal");
                return false;
            }
            String filePathDefault = "./logs/" + Strings.trimLeft(key, String.valueOf(this.id) + ".") + ".log";
            Group group = Global.getGroup(key);
            String mustName = group.getString("must.name");
            String mustClass = group.getString("must.class");
            LogConfig config = new LogConfig();
            config.setId(key);
            config.setLevelMin(levelMin);
            config.setLevelMax(levelMax);
            config.setConsoleOut(group.isTrue("console.out"));
            config.setConsolePattern(group.getString("console.pattern", "%d [%t] %l - %m%n"));
            config.setFileOut(group.isTrue("file.out"));
            config.setFilePath(group.getString("file.path", filePathDefault));
            config.setFilePattern(group.getString("file.pattern", "%d [%t] %l - %m%n"));
            config.setFileEncoding(group.getString("file.encoding", "UTF-8"));
            config.setFileMaxNum(group.getInt("file.maxNum", 7));
            config.setFileMaxSize(group.getInt("file.maxSize", 100));
            config.setMustName(mustName);
            if (Validates.isNotEmptyBlank(mustClass)) {
                Class<?> mustClazz = Global.forName(mustClass);
                config.setMustClass(mustClazz);
            }
            if (config.isConsoleOut()) {
                config.setConsoleAppender(new ConsoleAppender(config.getConsolePattern()));
            }
            if (config.isFileOut()) {
                String appenderClass = group.getString("file.appender");
                FileAppender appender = null;
                if (Validates.isEmpty(appenderClass)) {
                    appender = new FileDailyAppender();
                } else {
                    Class<?> appenderCls = Global.forName(appenderClass);
                    Object obj = appenderCls.newInstance();
                    if (!(obj instanceof FileAppender)) {
                        System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + group.getId() + "]file.appender\u672a\u5b9e\u73b0LogAppender\u63a5\u53e3");
                        return false;
                    }
                    appender = (FileAppender)obj;
                }
                appender.setFilePattern(config.getFilePattern());
                appender.setFileEncoding(config.getFileEncoding());
                appender.setFileMaxNum(config.getFileMaxNum());
                appender.setFileMaxSize(config.getFileMaxSize());
                appender.setFilePath(config.getFilePath());
                config.setFileAppender(appender);
            }
            if (mustClass != null) {
                map = (LoggerWapper)mustClassMap.get(config.getMustClass());
                if (map == null) {
                    map = new LoggerWapper();
                    mustClassMap.put(config.getMustClass(), map);
                }
                this.putWapper(config, map);
                continue;
            }
            if (Validates.isNotEmpty(mustName)) {
                map = (LoggerWapper)mustNameMap.get(mustName);
                if (map == null) {
                    map = new LoggerWapper();
                    mustNameMap.put(mustName, map);
                }
                this.putWapper(config, map);
                continue;
            }
            this.putWapper(config, defaultWapper);
        }
        LogFactory.updateLogService(this);
        return true;
    }

    private void putWapper(LogConfig config, LoggerWapper map) {
        int min = config.getLevelMin();
        int max = config.getLevelMax();
        ZhiqimLogger logger = new ZhiqimLogger();
        logger.setLevelMin(min);
        logger.setLevelMax(max);
        if (config.isConsoleOut()) {
            logger.add(config.getConsoleAppender());
        }
        if (config.isFileOut()) {
            logger.add(config.getFileAppender());
        }
        int i = min;
        while (i <= max) {
            map.put(i, logger);
            ++i;
        }
    }

    @Override
    public void destroy() throws Exception {
        mustNameMap.clear();
        mustClassMap.clear();
        defaultWapper.clear();
    }

    @Override
    public boolean isEnabled(Log log, int level) {
        return this.getLogger(log, level) != null;
    }

    @Override
    @AnNullable
    public ZhiqimLogger getLogger(Log log, int level) {
        if (Validates.isNotEmpty(log.getLogName())) {
            LoggerWapper wapper = (LoggerWapper)mustNameMap.get(log.getLogName());
            if (wapper == null) {
                return defaultWapper.get(level);
            }
            return wapper.get(level);
        }
        if (log.getLogClass() != null) {
            LoggerWapper wapper = (LoggerWapper)mustClassMap.get(log.getLogClass());
            if (wapper == null) {
                return defaultWapper.get(level);
            }
            return wapper.get(level);
        }
        return defaultWapper.get(level);
    }
}

