/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging;

import java.io.File;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.logging.LogLinuxCutter;
import org.zhiqim.kernel.schedule.ScheduleFactory;
import org.zhiqim.kernel.schedule.Scheduler;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Systems;

public class LogLinuxNohupCutter
extends LogLinuxCutter {
    private static final Log log = LogFactory.getLog(LogLinuxNohupCutter.class);

    @Override
    public boolean create() throws Exception {
        if (!Systems.isLinux()) {
            return true;
        }
        this.filePath = "./nohup.out";
        File file = new File(this.filePath);
        if (!Files.isFile(file) || !file.canRead()) {
            log.error((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s]\u4e0d\u5b58\u5728[./nohup.out]\uff0c\u4e0d\u5904\u7406", this.id);
            return false;
        }
        this.fileName = file.getName();
        this.fileBakDir = this.fileDir = Files.toLinuxPath(file.getParentFile().getCanonicalPath());
        this.maxNum = 1;
        this.keepLogNum = 30;
        this.schedule = "{name:Day, time:5/29/31, first:false}";
        TaskThreader threader = ScheduleFactory.getTaskThreader((Task)this, this.schedule);
        this.scheduler = Global.getService(Scheduler.class);
        if (this.scheduler == null) {
            this.scheduler = Global.getWithoutNew(Scheduler.class);
            this.scheduler.create();
            this.schedulerCreated = true;
        }
        this.taskId = this.scheduler.addTask(threader);
        log.info((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s][%s]\u521d\u59cb\u5316\u5b8c\u6210!!!", this.id, this.filePath);
        return true;
    }
}

