/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging;

import org.zhiqim.kernel.logging.LogConstants;
import org.zhiqim.kernel.logging.LogFormat;
import org.zhiqim.kernel.logging.LogService;
import org.zhiqim.kernel.logging.Logger;
import org.zhiqim.kernel.util.Strings;

public class Log
implements LogConstants {
    private final String logName;
    private final Class<?> logClass;
    private LogService logService;

    Log(String logName, LogService logService) {
        this.logName = logName;
        this.logClass = null;
        this.logService = logService;
    }

    Log(Class<?> logClass, LogService logService) {
        this.logName = null;
        this.logClass = logClass;
        this.logService = logService;
    }

    void setLogService(LogService logService) {
        this.logService = logService;
    }

    public void debug(Object message) {
        this.append(1, message, null);
    }

    public void debug(Throwable throwable) {
        this.append(1, null, throwable);
    }

    public void debug(Object message, Object ... arguments) {
        this.append(1, message, null, LogFormat.STRING, arguments);
    }

    public void debug(Object message, Throwable throwable, Object ... arguments) {
        this.append(1, message, throwable, LogFormat.STRING, arguments);
    }

    public void debug(Object message, LogFormat format, Object ... arguments) {
        this.append(1, message, null, format, arguments);
    }

    public void debug(Object message, Throwable throwable, LogFormat format, Object ... arguments) {
        this.append(1, message, throwable, format, arguments);
    }

    public void info(Object message) {
        this.append(2, message, null);
    }

    public void info(Throwable throwable) {
        this.append(2, null, throwable);
    }

    public void info(Object message, Object ... arguments) {
        this.append(2, message, null, LogFormat.STRING, arguments);
    }

    public void info(Object message, Throwable throwable, Object ... arguments) {
        this.append(2, message, throwable, LogFormat.STRING, arguments);
    }

    public void info(Object message, LogFormat format, Object ... arguments) {
        this.append(2, message, null, format, arguments);
    }

    public void info(Object message, Throwable throwable, LogFormat format, Object ... arguments) {
        this.append(2, message, throwable, format, arguments);
    }

    public void error(Object message) {
        this.append(3, message, null);
    }

    public void error(Throwable throwable) {
        this.append(3, null, throwable);
    }

    public void error(Object message, Object ... arguments) {
        this.append(3, message, null, LogFormat.STRING, arguments);
    }

    public void error(Object message, Throwable throwable, Object ... arguments) {
        this.append(3, message, throwable, LogFormat.STRING, arguments);
    }

    public void error(Object message, LogFormat format, Object ... arguments) {
        this.append(3, message, null, format, arguments);
    }

    public void error(Object message, Throwable throwable, LogFormat format, Object ... arguments) {
        this.append(3, message, throwable, format, arguments);
    }

    public void warn(Object message) {
        this.append(4, message, null);
    }

    public void warn(Throwable throwable) {
        this.append(4, null, throwable);
    }

    public void warn(Object message, Object ... arguments) {
        this.append(4, message, null, LogFormat.STRING, arguments);
    }

    public void warn(Object message, Throwable throwable, Object ... arguments) {
        this.append(4, message, throwable, LogFormat.STRING, arguments);
    }

    public void warn(Object message, LogFormat format, Object ... arguments) {
        this.append(4, message, null, format, arguments);
    }

    public void warn(Object message, Throwable throwable, LogFormat format, Object ... arguments) {
        this.append(4, message, throwable, format, arguments);
    }

    public void fatal(Object message) {
        this.append(5, message, null);
    }

    public void fatal(Throwable throwable) {
        this.append(5, null, throwable);
    }

    public void fatal(Object message, Object ... arguments) {
        this.append(5, message, null, LogFormat.STRING, arguments);
    }

    public void fatal(Object message, Throwable throwable, Object ... arguments) {
        this.append(5, message, throwable, LogFormat.STRING, arguments);
    }

    public void fatal(Object message, LogFormat format, Object ... arguments) {
        this.append(5, message, null, format, arguments);
    }

    public void fatal(Object message, Throwable throwable, LogFormat format, Object ... arguments) {
        this.append(5, message, throwable, format, arguments);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(1);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(2);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(3);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(4);
    }

    public boolean isFatalEnabled() {
        return this.isEnabled(5);
    }

    private void append(int level, Object message, Throwable throwable) {
        Logger logger = this.logService.getLogger(this, level);
        if (logger == null || !logger.isEnabled(this, level)) {
            return;
        }
        logger.append(this, level, String.valueOf(message), throwable);
    }

    private void append(int level, Object message, Throwable throwable, LogFormat format, Object ... arguments) {
        Logger logger = this.logService.getLogger(this, level);
        if (logger == null || !logger.isEnabled(this, level)) {
            return;
        }
        String msg = String.valueOf(message);
        if (arguments.length > 0 && (format == LogFormat.STRING || format == LogFormat.BOTH)) {
            msg = Strings.format(msg, arguments);
        }
        if (arguments.length > 0 && (format == LogFormat.STRING || format == LogFormat.BOTH)) {
            msg = Strings.formatMessage(msg, arguments);
        }
        logger.append(this, level, msg, throwable);
    }

    private boolean isEnabled(int level) {
        return this.logService.isEnabled(this, level);
    }

    public String getLogName() {
        return this.logName;
    }

    public Class<?> getLogClass() {
        return this.logClass;
    }

    public LogService getLogService() {
        return this.logService;
    }

    public String getLogNameOrClassName() {
        return this.logClass != null ? this.logClass.getName() : this.logName;
    }
}

