/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.json.parser;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.LinkedMapSS;
import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.json.parser.MapParser;
import org.zhiqim.kernel.util.Annotations;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Validates;

public class ObjectParser
implements JsonParser {
    private Json jsonMain;

    @Override
    public JsonParser set(Json jsonMain) {
        this.jsonMain = jsonMain;
        return this;
    }

    @Override
    public String toString(Object obj) {
        StringBuilder strb = new StringBuilder("{");
        Class<?> cls = obj.getClass();
        List<Field> fieldList = Classes.getFieldListDeep(cls);
        for (Field field : fieldList) {
            String name = Annotations.getFieldName(field);
            Object value = null;
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                value = field.get(obj);
            }
            catch (Exception exception) {}
            if (value == null) continue;
            strb.append("\"").append(name).append("\":").append(this.jsonMain.toString(value)).append(",");
        }
        if (strb.length() > 1) {
            strb.setLength(strb.length() - 1);
        }
        strb.append("}");
        return strb.toString();
    }

    @Override
    public Object toObject(String json, Class<?> cls) {
        HashMapSS map = this.toMap(json);
        Object obj = Classes.newInstance(cls);
        if (obj == null) {
            return null;
        }
        List<Field> fieldList = Classes.getFieldListDeep(cls);
        for (Field field : fieldList) {
            Class<?> genericsClass;
            String name = Annotations.getFieldName(field);
            String value = map.get(name);
            if (value == null) continue;
            Class<?> type = field.getType();
            Object vo = this.jsonMain.toObject(value, type, false);
            if (Classes.isCollection(type)) {
                genericsClass = Annotations.getGenericsClass(field);
                if (genericsClass != null) {
                    Collection cList = (Collection)vo;
                    ArrayList<String> strList = new ArrayList<String>();
                    for (Object object : cList) {
                        strList.add((String)object);
                    }
                    cList.clear();
                    for (String string : strList) {
                        Object o = this.jsonMain.toObject(string, genericsClass, false);
                        cList.add(o);
                    }
                    vo = cList;
                }
            } else if (Classes.isMap(type) && (genericsClass = Annotations.getGenericsClass(field)) != null) {
                Map cMap = (Map)vo;
                LinkedMapSS strMap = new LinkedMapSS();
                for (Map.Entry entry : cMap.entrySet()) {
                    strMap.put((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
                cMap.clear();
                for (Map.Entry entry : strMap.entrySet()) {
                    Object v = this.jsonMain.toObject((String)entry.getValue(), genericsClass, false);
                    cMap.put((String)entry.getKey(), v);
                }
                vo = cMap;
            }
            Classes.setFieldValue(obj, field, vo);
        }
        return obj;
    }

    private HashMapSS toMap(String json) {
        if (Validates.isEmpty(json)) {
            return new HashMapSS(0);
        }
        HashMapSS map = new HashMapSS();
        List<String> fieldList = MapParser.toFieldList(json);
        for (String s : fieldList) {
            int ind = s.indexOf(":");
            String key = Jsons.removeStartEndQuotation(s.substring(0, ind));
            String value = s.substring(ind + 1);
            if ("null".equals(value)) {
                map.put(key, null);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }
}

