/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.json.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Validates;

public class MapSSParser
implements JsonParser {
    @Override
    public JsonParser set(Json jsonMain) {
        return this;
    }

    @Override
    public String toString(Object obj) {
        MapSS map = (MapSS)obj;
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder strb = new StringBuilder("{");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            strb.append("\"").append(key).append("\":\"").append(value).append("\"").append(",");
        }
        strb.setLength(strb.length() - 1);
        strb.append("}");
        return strb.toString();
    }

    @Override
    public Object toObject(String json, Class<?> cls) {
        MapSS map = Classes.newMapSS(cls);
        if (map == null) {
            return null;
        }
        List<String> fieldList = MapSSParser.toFieldList(json);
        for (String s : fieldList) {
            int ind = s.indexOf(":");
            String key = Jsons.removeStartEndQuotation(s.substring(0, ind));
            String value = s.substring(ind + 1);
            if ("null".equals(value)) {
                map.put(key, null);
                continue;
            }
            if (Jsons.isStartEndQuotation(value)) {
                value = Jsons.removeStartEndQuotation(value);
            }
            value = Jsons.removeEscapeChar(value);
            map.put(key, value);
        }
        return map;
    }

    public static List<String> toFieldList(String json) {
        if (Validates.isEmptyBlank(json)) {
            return new ArrayList<String>();
        }
        if (!json.startsWith("{") || !json.endsWith("}")) {
            return new ArrayList<String>();
        }
        json = json.substring(1, json.length() - 1);
        return Jsons.getFieldList(json);
    }
}

