/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.json.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Validates;

public class MapParser
implements JsonParser {
    private Json jsonMain;

    @Override
    public JsonParser set(Json jsonMain) {
        this.jsonMain = jsonMain;
        return this;
    }

    @Override
    public String toString(Object obj) {
        Map map = (Map)obj;
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder strb = new StringBuilder("{");
        for (Map.Entry entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            strb.append("\"").append(key).append("\":").append(this.jsonMain.toString(value)).append(",");
        }
        strb.setLength(strb.length() - 1);
        strb.append("}");
        return strb.toString();
    }

    @Override
    public Object toObject(String json, Class<?> cls) {
        Map<String, Object> map = Classes.newMap(cls);
        if (map == null) {
            return null;
        }
        List<String> fieldList = MapParser.toFieldList(json);
        for (String s : fieldList) {
            int ind = s.indexOf(":");
            String key = Jsons.removeStartEndQuotation(s.substring(0, ind));
            String value = s.substring(ind + 1);
            if ("null".equals(value)) {
                map.put(key, null);
                continue;
            }
            if (Jsons.isStartEndQuotation(value)) {
                map.put(key, Jsons.removeEscapeChar(Jsons.removeStartEndQuotation(value)));
                continue;
            }
            if (Validates.isInteger(value)) {
                map.put(key, Long.parseLong(value));
                continue;
            }
            if (Validates.isFloat(value)) {
                map.put(key, Double.parseDouble(value));
                continue;
            }
            if ("true".equalsIgnoreCase(value)) {
                map.put(key, true);
                continue;
            }
            if ("false".equalsIgnoreCase(value)) {
                map.put(key, false);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<String> toFieldList(String json) {
        if (Validates.isEmptyBlank(json)) {
            return new ArrayList<String>();
        }
        if (!json.startsWith("{") || !json.endsWith("}")) {
            return new ArrayList<String>();
        }
        json = json.substring(1, json.length() - 1);
        return Jsons.getFieldList(json);
    }
}

