/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.zhiqim.kernel.httpclient.HttpClient;
import org.zhiqim.kernel.httpclient.HttpResult;
import org.zhiqim.kernel.util.Streams;

public class HttpStream
extends HttpClient {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private ByteArrayOutputStream in;

    public HttpStream(String url, String method) {
        super(url, method);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void write(int b) {
        this.out.write(b);
    }

    public void write(byte[] b) {
        this.out.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        this.out.write(b, off, len);
    }

    @Override
    public HttpResult getResult() {
        return new HttpResult(this.responseStatus, this.responseText, this.in == null ? null : this.in.toByteArray());
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.in.toByteArray());
    }

    public byte[] getBytes() {
        return this.in.toByteArray();
    }

    @Override
    protected boolean doPreRequestProperty() {
        this.setDoOutput(true);
        return true;
    }

    @Override
    protected void doWriteRequestContent(HttpURLConnection conn) throws IOException {
        this.out.writeTo(conn.getOutputStream());
    }

    @Override
    protected void doReadResponseContent(HttpURLConnection conn) throws IOException {
        if (this.responseStatus == 302) {
            this.responseText = conn.getHeaderField("Location");
            return;
        }
        if (this.responseStatus != 200) {
            this.responseText = HttpStream.getResponseError(conn);
            return;
        }
        this.in = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = conn.getInputStream();){
            Streams.putBytes(input, this.in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.responseText = "\u8c03\u7528\u6210\u529f";
    }
}

