/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.zhiqim.kernel.httpclient.HttpClient;
import org.zhiqim.kernel.httpclient.HttpResult;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Stringx;
import org.zhiqim.kernel.util.Validates;

public class HttpPostStream
extends HttpClient {
    private String queryString;
    private String mimeType = "application/x-www-form-urlencoded";
    private String encoding = "UTF-8";
    private ByteArrayOutputStream in;

    public HttpPostStream(String url) {
        super(url, "POST");
    }

    public void setQueryString(String queryString, String encoding) {
        this.queryString = Stringx.trim(queryString);
        this.encoding = Stringx.trim(encoding);
    }

    public void setQueryString(String queryString, String mimeType, String encoding) {
        this.queryString = Stringx.trim(queryString);
        this.mimeType = Stringx.trim(mimeType);
        this.encoding = Stringx.trim(encoding);
    }

    @Override
    public HttpResult getResult() {
        return new HttpResult(this.responseStatus, this.responseText, this.in == null ? null : this.in.toByteArray());
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.in.toByteArray());
    }

    public byte[] getBytes() {
        return this.in.toByteArray();
    }

    @Override
    protected boolean doPreRequestProperty() {
        if (Validates.isEmpty(this.queryString)) {
            return true;
        }
        this.setDoOutput(true);
        this.addRequestProperty("Content-Type", String.valueOf(this.mimeType) + "; charset=" + this.encoding);
        this.addRequestProperty("Content-Length", Bytes.getByteLen(this.queryString, this.encoding));
        return true;
    }

    @Override
    protected void doWriteRequestContent(HttpURLConnection conn) throws IOException {
        if (Validates.isEmpty(this.queryString)) {
            return;
        }
        conn.getOutputStream().write(this.queryString.getBytes(this.encoding));
    }

    @Override
    protected void doReadResponseContent(HttpURLConnection conn) throws IOException {
        if (this.responseStatus == 302) {
            this.responseText = conn.getHeaderField("Location");
            return;
        }
        if (this.responseStatus != 200) {
            this.responseText = HttpPostStream.getResponseError(conn);
            return;
        }
        this.in = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = conn.getInputStream();){
            Streams.putBytes(input, this.in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.responseText = "\u8c03\u7528\u6210\u529f";
    }
}

