/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.httpclient;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.zhiqim.kernel.httpclient.HttpClient;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Stringx;
import org.zhiqim.kernel.util.Validates;

public class HttpPost
extends HttpClient {
    private String queryString;
    private String mimeType = "application/x-www-form-urlencoded";
    private String encoding = "UTF-8";

    public HttpPost(String url) {
        super(url, "POST");
    }

    public void setQueryString(String queryString, String encoding) {
        this.queryString = Stringx.trim(queryString);
        this.encoding = Stringx.trim(encoding);
    }

    public void setQueryString(String queryString, String mimeType, String encoding) {
        this.queryString = Stringx.trim(queryString);
        this.mimeType = Stringx.trim(mimeType);
        this.encoding = Stringx.trim(encoding);
    }

    @Override
    protected boolean doPreRequestProperty() {
        if (Validates.isEmpty(this.queryString)) {
            return true;
        }
        this.setDoOutput(true);
        this.addRequestProperty("Content-Type", String.valueOf(this.mimeType) + "; charset=" + this.encoding);
        this.addRequestProperty("Content-Length", Bytes.getByteLen(this.queryString, this.encoding));
        return true;
    }

    @Override
    protected void doWriteRequestContent(HttpURLConnection conn) throws IOException {
        if (Validates.isEmpty(this.queryString)) {
            return;
        }
        conn.getOutputStream().write(this.queryString.getBytes(this.encoding));
    }
}

