/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.zhiqim.kernel.constants.HttpConstants;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.httpclient.HttpClientRequest;
import org.zhiqim.kernel.httpclient.HttpResult;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Stringx;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.SSL;
import org.zhiqim.kernel.util.consts.Int;

public abstract class HttpClient
implements HttpConstants {
    public static final String _USER_AGENT_VALUE_ = "ZhiqimHttpClient/V1.4.0";
    public static final Pattern _REGEX_FILE_NAME_ = Pattern.compile("attachment;\\s*filename=\"([\\w\\-\\._]+)\"");
    protected static final Log log = LogFactory.getLog(HttpClient.class);
    private int connectTimeout = 10;
    private int readTimeout = 30;
    private boolean doInput = true;
    private boolean doOutput = false;
    private boolean instanceFollowRedirects = false;
    private boolean useCaches = false;
    private long ifModifiedSince = 0L;
    private int chunkLength = -1;
    private int fixedContentLength = -1;
    private boolean allowUserInteraction = false;
    private boolean hasUserAgent = false;
    private HashMapSS requestPropertyMap;
    private HashMapSS responsePropertyMap;
    private String responseStatusLine;
    protected String url;
    private String method;
    private X509TrustManager trustManager;
    protected int responseStatus;
    protected String responseText;

    public HttpClient(String url, String method) {
        this.url = url;
        this.method = method;
        this.requestPropertyMap = new HashMapSS();
        this.responsePropertyMap = new HashMapSS();
    }

    public final void execute() {
        if (!this.isValidUrl()) {
            return;
        }
        HttpURLConnection conn = null;
        try {
            if (!this.doPreRequestProperty()) {
                return;
            }
            try {
                conn = this.newHttpConnection();
                conn.connect();
                this.doWriteRequestContent(conn);
                this.responseStatus = conn.getResponseCode();
                this.doReadResponseProperty(conn);
                this.doReadResponseContent(conn);
            }
            catch (SocketTimeoutException e) {
                this.responseStatus = 73;
                this.responseText = "\u8c03\u7528\u670d\u52a1\u7aef\u8d85\u65f6";
                log.error((Object)this.responseText, (Throwable)e, new Object[0]);
            }
            catch (ConnectException e) {
                this.responseStatus = 91;
                this.responseText = "\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25";
                log.error((Object)this.responseText, (Throwable)e, new Object[0]);
            }
            catch (SocketException e) {
                this.responseStatus = 90;
                this.responseText = "\u8c03\u7528\u670d\u52a1\u7aef\u5931\u8d25:" + e.getMessage();
                log.error((Object)this.responseText, (Throwable)e, new Object[0]);
            }
            catch (IOException e) {
                this.responseStatus = 98;
                this.responseText = "\u8c03\u7528\u670d\u52a1\u7aef\u5931\u8d25:" + e.getMessage();
                log.error((Object)this.responseText, (Throwable)e, new Object[0]);
            }
            catch (Exception e) {
                this.responseStatus = 99;
                this.responseText = "\u8c03\u7528\u670d\u52a1\u7aef\u5f02\u5e38:" + e.getMessage();
                log.error((Object)this.responseText, (Throwable)e, new Object[0]);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected boolean doPreRequestProperty() {
        return true;
    }

    protected void doWriteRequestContent(HttpURLConnection conn) throws IOException {
    }

    protected void doReadResponseContent(HttpURLConnection conn) throws IOException {
        if (this.responseStatus == 302) {
            this.responseText = conn.getHeaderField("Location");
            return;
        }
        this.responseText = HttpClient.getResponseAsString(conn);
    }

    private boolean isValidUrl() {
        if (Validates.isUrl(this.url)) {
            return true;
        }
        this.responseStatus = 70;
        this.responseText = "\u8bf7\u6c42\u7684URL\u4e0d\u6b63\u786e";
        return false;
    }

    private HttpURLConnection newHttpConnection() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        if (Validates.isUrlHttp(this.url)) {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.url).openConnection();
            this.setConnectionProperty(conn);
            return conn;
        }
        SSLContext ctx = SSLContext.getInstance(Systems.isJavaVersionMoreThen7() ? "TLSv1.2" : "TLSv1");
        ctx.init(null, new TrustManager[]{this.trustManager != null ? this.trustManager : new SSL.DefaultTrustManager()}, new SecureRandom());
        HttpsURLConnection conn = (HttpsURLConnection)new URL(this.url).openConnection();
        conn.setSSLSocketFactory(ctx.getSocketFactory());
        conn.setHostnameVerifier(new SSL.DefaultHostnameVerifier());
        this.setConnectionProperty(conn);
        return conn;
    }

    private void setConnectionProperty(HttpURLConnection conn) {
        try {
            conn.setRequestMethod(this.method);
        }
        catch (ProtocolException protocolException) {}
        if (!this.doInput) {
            conn.setDoInput(this.doInput);
        }
        if (this.doOutput) {
            conn.setDoOutput(this.doOutput);
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        if (this.connectTimeout > 0) {
            conn.setConnectTimeout(this.connectTimeout * 1000);
        }
        if (this.readTimeout > 0) {
            conn.setReadTimeout(this.readTimeout * 1000);
        }
        if (!this.useCaches) {
            conn.setUseCaches(this.useCaches);
        }
        if (this.ifModifiedSince > 0L) {
            conn.setIfModifiedSince(this.ifModifiedSince);
        }
        if (this.fixedContentLength != -1) {
            conn.setFixedLengthStreamingMode(this.fixedContentLength);
        }
        if (this.fixedContentLength == -1 && this.chunkLength != -1) {
            conn.setChunkedStreamingMode(this.chunkLength);
        }
        if (this.allowUserInteraction) {
            conn.setAllowUserInteraction(this.allowUserInteraction);
        }
        if (this.requestPropertyMap != null && !this.requestPropertyMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.requestPropertyMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (!this.hasUserAgent) {
            conn.addRequestProperty("User-Agent", _USER_AGENT_VALUE_);
        }
    }

    public void setRequest(HttpClientRequest request) {
        request.buildRequest(this);
    }

    public void setTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public void setConnectionClose() {
        this.requestPropertyMap.put("Connection", "Close");
    }

    public void addRequestProperty(String key, int value) {
        this.addRequestProperty(key, String.valueOf(value));
    }

    public void addRequestProperty(String key, String value) {
        if ("User-Agent".equalsIgnoreCase(key)) {
            this.hasUserAgent = true;
        }
        this.requestPropertyMap.put(key, value);
    }

    public HashMapSS getRequestPropertyMap() {
        return this.requestPropertyMap;
    }

    public String getRequestProperty(String key) {
        return this.requestPropertyMap.get(key);
    }

    public boolean hasRequestProperty(String key) {
        return this.requestPropertyMap.containsKey(key);
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isDoInput() {
        return this.doInput;
    }

    public void setDoInput(boolean doInput) {
        this.doInput = doInput;
    }

    public boolean isDoOutput() {
        return this.doOutput;
    }

    public void setDoOutput(boolean doOutput) {
        this.doOutput = doOutput;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }

    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.ifModifiedSince = ifModifiedSince;
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public void setChunkLength(int chunkLength) {
        this.chunkLength = chunkLength;
    }

    public int getFixedContentLength() {
        return this.fixedContentLength;
    }

    public void setFixedContentLength(int fixedContentLength) {
        this.fixedContentLength = fixedContentLength;
    }

    public boolean isAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public void setAllowUserInteraction(boolean allowUserInteraction) {
        this.allowUserInteraction = allowUserInteraction;
    }

    public boolean isInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public void setInstanceFollowRedirects(boolean instanceFollowRedirects) {
        this.instanceFollowRedirects = instanceFollowRedirects;
    }

    protected void doReadResponseProperty(URLConnection conn) {
        this.responseStatusLine = conn.getHeaderField(0);
        Map<String, List<String>> map = conn.getHeaderFields();
        for (String key : map.keySet()) {
            if (key == null) continue;
            this.responsePropertyMap.put(key.toLowerCase(), conn.getHeaderField(key));
        }
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public boolean isResponseSuccess() {
        return this.responseStatus == 200;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public HttpResult getResult() {
        return new HttpResult(this.responseStatus, this.responseText);
    }

    public Int getResultInt() {
        return new Int(this.responseStatus == 200 ? 0 : this.responseStatus, this.responseText);
    }

    public String getResponseStatusLine() {
        return this.responseStatusLine;
    }

    public String getResponseProperty(String key) {
        return this.responsePropertyMap.get(key.toLowerCase());
    }

    public boolean hasResponseProperty(String key) {
        return this.responsePropertyMap.containsKey(key.toLowerCase());
    }

    public HashMapSS getResponsePropertyMap() {
        return this.responsePropertyMap;
    }

    public List<String> getResponseList() {
        return new ArrayList<String>(this.responsePropertyMap.values());
    }

    public int getResponseContentLength() {
        String value = this.responsePropertyMap.get("Content-Length".toLowerCase());
        if (Validates.isEmptyBlank(value)) {
            return 0;
        }
        if (!Validates.isIntegerPositive(value = value.trim())) {
            return 0;
        }
        return Ints.toInt(value);
    }

    public String getResponseContentType() {
        return this.getResponseProperty("Content-Type");
    }

    public String getResponseCharset() {
        return HttpClient.getResponseCharset(this.getResponseContentType());
    }

    public String getResponseContentEncoding() {
        return this.getResponseProperty("Content-Encoding");
    }

    public boolean isResponseGzip() {
        return "gzip".equals(this.getResponseContentEncoding());
    }

    public static boolean isResponseGzip(HttpURLConnection conn) {
        return "gzip".equals(conn.getContentEncoding());
    }

    public static String getResponseCharset(String contentType) {
        String[] params;
        if (Validates.isEmptyBlank(contentType)) {
            return "UTF-8";
        }
        String[] stringArray = params = Arrays.toStringArray(contentType.trim(), ";");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair;
            String param = stringArray[n2];
            if (param.startsWith("charset") && (pair = Arrays.toStringArray(param, "=")).length == 2 && !Validates.isEmpty(pair[1])) {
                return pair[1];
            }
            ++n2;
        }
        return "UTF-8";
    }

    public static String getResponseAsString(HttpURLConnection conn) throws IOException {
        boolean isGzip = HttpClient.isResponseGzip(conn);
        String charset = HttpClient.getResponseCharset(conn.getContentType());
        if (conn.getErrorStream() != null) {
            String message = null;
            message = isGzip ? Streams.getStringGzip(conn.getErrorStream(), charset) : Streams.getString(conn.getErrorStream(), charset);
            if (Validates.isEmptyBlank(message)) {
                message = "\u8c03\u7528\u670d\u52a1\u7aef\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + conn.getResponseCode();
            }
            return message;
        }
        if (conn.getInputStream() != null) {
            if (isGzip) {
                return Streams.getStringGzip(conn.getInputStream(), charset);
            }
            return Streams.getString(conn.getInputStream(), charset);
        }
        return "\u8c03\u7528\u670d\u52a1\u7aef\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + conn.getResponseCode();
    }

    public static String getResponseError(HttpURLConnection conn) throws IOException {
        InputStream stream = conn.getErrorStream();
        if (stream == null) {
            return "\u8c03\u7528\u670d\u52a1\u7aef\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + conn.getResponseCode();
        }
        boolean isGzip = HttpClient.isResponseGzip(conn);
        String charset = HttpClient.getResponseCharset(conn.getContentType());
        String message = null;
        message = isGzip ? Streams.getStringGzip(stream, charset) : Streams.getString(stream, charset);
        if (Validates.isEmptyBlank(message)) {
            message = "\u8c03\u7528\u670d\u52a1\u7aef\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + conn.getResponseCode();
        }
        return message;
    }

    public static String getFileName(HttpURLConnection conn) {
        String contentDisposition = conn.getHeaderField("Content-Disposition");
        if (contentDisposition == null) {
            return null;
        }
        Matcher matcher = _REGEX_FILE_NAME_.matcher(contentDisposition);
        if (matcher.find()) {
            return Stringx.trim(matcher.group(1));
        }
        return null;
    }

    public static byte[] getTextDisposition(String name, String encoding) throws IOException {
        StringBuilder strb = new StringBuilder().append("Content-Disposition: form-data; name=\"").append(name).append("\"").append("\r\n").append("\r\n");
        return strb.toString().getBytes(encoding);
    }

    public static byte[] getFileDisposition(String name, String fileName, String mimeType, String encoding) throws IOException {
        StringBuilder strb = new StringBuilder().append("Content-Disposition: form-data; name=\"").append(name).append("\"; filename=\"").append(fileName).append("\"").append("\r\n").append("Content-Type:").append(mimeType).append("\r\n").append("\r\n");
        return strb.toString().getBytes(encoding);
    }
}

