/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.extend;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.extend.HashMapSC;
import org.zhiqim.kernel.extend.MapSC;
import org.zhiqim.kernel.util.Asserts;

@AnAlias(value={"LinkedMapSC"})
@AnNew
public class LinkedMapSC
extends HashMapSC {
    public LinkedMapSC() {
        this.instance = new LinkedHashMap();
    }

    public LinkedMapSC(int count) {
        this.instance = new LinkedHashMap(count);
    }

    public LinkedMapSC(int initialCapacity, float loadFactor, boolean accessOrder) {
        this.instance = new LinkedHashMap(initialCapacity, loadFactor, accessOrder);
    }

    public LinkedMapSC(String key, Class<?> value) {
        this.instance = new LinkedHashMap(1);
        this.instance.put(key, value);
    }

    public LinkedMapSC(Map<String, Class<?>> instance) {
        this.instance = new LinkedHashMap(instance);
    }

    public LinkedMapSC(MapSC instance) {
        this.instance = new LinkedHashMap(instance.instance());
    }

    public Object get(int index) {
        Asserts.asserts(index >= 0, ZhiqimI18n.indexMustBeGreaterThanOrEqualZero);
        if (index >= this.instance.size()) {
            return null;
        }
        Set entrySet = this.instance.entrySet();
        Iterator it = entrySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (index <= i) {
                if (index != i) break;
                return entry.getValue();
            }
            ++i;
        }
        return null;
    }
}

