/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.extend;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.MapCV;
import org.zhiqim.kernel.util.Asserts;

@AnAlias(value={"LinkedMapCV"})
@AnNew
public class LinkedMapCV<V>
extends HashMapCV<V> {
    private final LinkedHashMap<Class<?>, V> instance;

    public LinkedMapCV() {
        this.instance = new LinkedHashMap();
    }

    public LinkedMapCV(int count) {
        this.instance = new LinkedHashMap(count);
    }

    public LinkedMapCV(int initialCapacity, float loadFactor, boolean accessOrder) {
        this.instance = new LinkedHashMap(initialCapacity, loadFactor, accessOrder);
    }

    public LinkedMapCV(Class<?> key, V value) {
        this.instance = new LinkedHashMap(1);
        this.instance.put(key, value);
    }

    public LinkedMapCV(Map<Class<?>, V> instance) {
        this.instance = new LinkedHashMap(instance);
    }

    public LinkedMapCV(MapCV<V> instance) {
        this.instance = new LinkedHashMap(instance.instance());
    }

    public Object[] toArray() {
        return this.instance.values().toArray();
    }

    public V get(int index) {
        Asserts.asserts(index >= 0, ZhiqimI18n.indexMustBeGreaterThanOrEqualZero);
        if (index >= this.instance.size()) {
            return null;
        }
        Set<Map.Entry<Class<?>, V>> entrySet = this.instance.entrySet();
        Iterator<Map.Entry<Class<?>, V>> it = entrySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<Class<?>, V> entry = it.next();
            if (index <= i) {
                if (index != i) break;
                return entry.getValue();
            }
            ++i;
        }
        return null;
    }
}

