/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.control;

import org.zhiqim.kernel.util.Threads;

public abstract class Threadx
implements Runnable,
AutoCloseable {
    private volatile boolean isRunning;
    private Thread thread;
    private long threadId;

    protected ThreadGroup getThreadGroup() {
        return null;
    }

    protected abstract String getThreadName();

    protected boolean openBefore() {
        return true;
    }

    protected boolean openAfter() {
        return true;
    }

    protected void closeBefore() {
    }

    protected void closeAfter() {
    }

    protected void first() {
    }

    protected abstract void loop();

    public final long getThreadId() {
        return this.threadId;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final synchronized boolean open() {
        if (this.isRunning) {
            return false;
        }
        try {
            if (!this.openBefore()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        this.thread = new Thread(this.getThreadGroup(), this, this.getThreadName());
        this.thread.start();
        while (!this.isRunning) {
            Threads.sleepIgnoreException(3);
        }
        this.threadId = this.thread.getId();
        try {
            if (!this.openAfter()) {
                this.close();
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    @Override
    public final synchronized void close() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        try {
            this.closeBefore();
        }
        catch (Throwable throwable) {}
        this.threadId = 0L;
        if (this.thread != null) {
            if (!this.thread.isInterrupted()) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        try {
            this.closeAfter();
        }
        catch (Throwable throwable) {}
    }

    public final synchronized void closeNotInterrupt() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        try {
            this.closeBefore();
        }
        catch (Throwable throwable) {}
        this.threadId = 0L;
        if (this.thread != null) {
            this.thread = null;
        }
        try {
            this.closeAfter();
        }
        catch (Throwable throwable) {}
    }

    @Override
    public final void run() {
        this.isRunning = true;
        try {
            this.first();
        }
        catch (Throwable throwable) {}
        while (this.isRunning) {
            try {
                this.loop();
            }
            catch (Throwable throwable) {}
        }
    }
}

