/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.control.Queue;
import org.zhiqim.kernel.control.ThreadServicer;
import org.zhiqim.kernel.control.Threader;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Threads;

public class ThreaderController
extends ThreadServicer {
    private static final Log log = LogFactory.getLog(ThreaderController.class);
    private volatile int poMinSize;
    private volatile int poMaxSize;
    private volatile int poIdleTimeMs;
    private volatile int poQueueSize;
    private volatile int threadTimeoutMs = 5000;
    private ThreadGroup threadGroup;
    private String threadName = "Threader-" + Randoms.upperLetters(1) + Randoms.lowerLettersDigits(3);
    private boolean isLogger;
    private final LinkedList<Threader> theaderList = new LinkedList();
    private final Queue<Runnable> queue = new Queue();
    private final AtomicInteger activeSize = new AtomicInteger();

    @Override
    protected final ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    protected final String getThreadName() {
        return "Controller-" + this.threadName;
    }

    public void setThreadTimeoutMs(int threadTimeoutMs) {
        this.threadTimeoutMs = threadTimeoutMs;
    }

    public void setThreadName(String threadName) {
        Asserts.as(!this.isRunning() ? null : "\u7ebf\u7a0b\u6c60\u521b\u5efa\u540e\u4e0d\u652f\u6301\u4fee\u6539");
        this.threadName = threadName;
    }

    public void setLogger(boolean isLogger) {
        this.isLogger = isLogger;
    }

    public ThreaderController set(int poMinSize, int poMaxSize, int poIdleTime, int poQueueSize) {
        this.poMinSize = poMinSize < 1 ? 1 : poMinSize;
        this.poMaxSize = poMaxSize < poMinSize ? poMinSize : poMaxSize;
        this.poIdleTimeMs = (poIdleTime < 60 ? 60 : poIdleTime) * 1000;
        this.poQueueSize = poQueueSize < this.poMaxSize * 3 ? this.poMaxSize * 3 : poQueueSize;
        return this;
    }

    @Override
    public boolean openBefore() {
        if (this.id != null) {
            this.threadName = Strings.toUpperFirstChar(this.id);
            Group grp = Global.getGroup(this.id);
            if (grp != null) {
                this.set(grp.getInt("poMinSize"), grp.getInt("poMaxSize"), grp.getInt("poIdleTime"), grp.getInt("poQueueSize"));
            }
        }
        Asserts.as((String)(this.poMaxSize >= this.poMinSize && this.poMinSize > 0 && this.poIdleTimeMs > 0 && this.poQueueSize > 0 ? null : "\u7ebf\u7a0b\u6c60\u670d\u52a1\u914d\u7f6e\u53c2\u6570\u4e0d\u6b63\u786e"));
        this.threadGroup = new ThreadGroup(this.threadName);
        int i = 0;
        while (i < this.poMinSize) {
            this.openThreader();
            ++i;
        }
        return true;
    }

    @Override
    public void closeAfter() {
        this.closeThreaders();
        log.info((Object)"\u7ebf\u7a0b\u6c60[%s]\u76d1\u89c6\u7ebf\u7a0b\u9000\u51fa", this.threadName);
    }

    @Override
    public void loop() {
        if (this.theaderList.size() > this.poMinSize) {
            this.chkThreaders();
        }
        log.info((Object)"\u7ebf\u7a0b\u6c60[name:%s,min:%d,max:%d,cur:%d,active:%d,queue:%d,idleTime:%d]", this.threadName, this.poMinSize, this.poMaxSize, this.theaderList.size(), this.activeSize.get(), this.queue.size(), this.poIdleTimeMs / 1000);
        Threads.sleepIgnoreException(this.poIdleTimeMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openThreader() {
        Threader threader = new Threader(this);
        threader.open();
        LinkedList<Threader> linkedList = this.theaderList;
        synchronized (linkedList) {
            this.theaderList.add(threader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeThreaders() {
        LinkedList<Threader> linkedList = this.theaderList;
        synchronized (linkedList) {
            for (Threader threader : this.theaderList) {
                threader.close();
                Object var2_3 = null;
            }
            this.theaderList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chkThreaders() {
        ArrayList<Threader> list = new ArrayList<Threader>();
        LinkedList<Threader> linkedList = this.theaderList;
        synchronized (linkedList) {
            Iterator it = this.theaderList.iterator();
            while (it.hasNext()) {
                if (this.theaderList.size() - list.size() <= this.poMinSize) break;
                Threader threader = (Threader)it.next();
                if (!threader.isIdleTimeout(this.poIdleTimeMs)) continue;
                list.add(threader);
            }
        }
        for (Threader threader : list) {
            if (!threader.isIdleTimeout(this.poIdleTimeMs)) continue;
            LinkedList<Threader> linkedList2 = this.theaderList;
            synchronized (linkedList2) {
                this.theaderList.remove(threader);
            }
            threader.close();
        }
        list.clear();
        list = null;
    }

    public boolean execute(Runnable command) {
        return this.execute(command, false);
    }

    public synchronized boolean execute(Runnable command, boolean priority) {
        if (!this.isRunning() || command == null) {
            return false;
        }
        int threaderSize = this.theaderList.size();
        int activeSize = this.getThreaderActiveSize();
        if (activeSize < threaderSize) {
            this.queue.post(command, priority);
            return true;
        }
        if (this.queue.size() < threaderSize) {
            this.queue.post(command, priority);
            return true;
        }
        if (threaderSize < this.poMaxSize) {
            this.openThreader();
            this.queue.post(command, priority);
            return true;
        }
        if (this.queue.size() < this.poQueueSize) {
            this.queue.post(command, priority);
            return true;
        }
        if (this.isLogger) {
            log.fatal((Object)"\u7ebf\u7a0b\u6c60[%s]\u7e41\u5fd9\u8d85\u9650\uff0c\u4e8b\u4ef6\u5bf9\u961f\u5df2\u6ee1\uff0c\u65e0\u6cd5\u63a5\u6536\u5904\u7406", this.threadName);
        }
        return false;
    }

    Runnable accept() {
        return this.queue.accept(this.threadTimeoutMs);
    }

    void active() {
        this.activeSize.getAndIncrement();
    }

    void idle() {
        this.activeSize.getAndDecrement();
    }

    public void clear() {
        this.queue.clear();
    }

    public boolean contains(Runnable command) {
        return this.queue.contains(command);
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Queue<Runnable> getQueue() {
        return this.queue;
    }

    public List<Threader> getThreaderList() {
        return Collections.unmodifiableList(this.theaderList);
    }

    public int getThreaderSize() {
        return this.theaderList.size();
    }

    public int getThreaderActiveSize() {
        return this.activeSize.get();
    }

    public int getThreaderIdleSize() {
        return this.theaderList.size() - this.activeSize.get();
    }

    public int getPoMinSize() {
        return this.poMinSize;
    }

    public int getPoMaxSize() {
        return this.poMaxSize;
    }

    public int getPoIdleTime() {
        return this.poIdleTimeMs / 1000;
    }

    public int getPoQueueSize() {
        return this.poQueueSize;
    }
}

