/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.constants;

import org.zhiqim.kernel.annotation.AnAlias;

@AnAlias(value={"RegexpConstants"})
public interface RegexpConstants {
    public static final String ESCAPE = "*.?+$^[](){}|\\/";
    public static final String NUMERIC = "^\\d+$";
    public static final String NUMERIC_N = "^\\d{n}$";
    public static final String NUMERIC_TN = "^\\d{n,}$";
    public static final String NUMERIC_N_M = "^\\d{n,m}$";
    public static final String INTEGER = "^(0|[\\+\\-]?[1-9]\\d*)$";
    public static final String INTEGER_P = "^[1-9]\\d*$";
    public static final String INTEGER_N = "^\\-[1-9]\\d*$";
    public static final String INTEGER_N_N = "^(0|[1-9]\\d*)$";
    public static final String INTEGER_N_P = "^(0|\\-[1-9]\\d*)$";
    public static final String FLOAT_INT = "^(0|[1-9]\\d*)(\\.\\d+)?$";
    public static final String FLOAT = "^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d+)?$";
    public static final String AMOUNT_INT_2R = "^(0|[1-9]\\d*)(\\.\\d{1,2})?$";
    public static final String AMOUNT_INT_2R_FIXED = "^(0|[1-9]\\d*)(\\.\\d{2})$";
    public static final String AMOUNT_2R = "^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d{1,2})?$";
    public static final String AMOUNT_2R_FIXED = "^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d{2})$";
    public static final String ALPHABAT = "^[A-Za-z]+$";
    public static final String ALPHABAT_UPPER = "^[A-Z]+$";
    public static final String ALPHABAT_LOWER = "^[a-z]+$";
    public static final String ALPHA_LOWER_NUMERIC = "^[a-z0-9]+$";
    public static final String ALPHA_UPPER_NUMERIC = "^[A-Z0-9]+$";
    public static final String ALPHA_NUMERIC = "^[A-Za-z0-9]+$";
    public static final String ALPHA_NUMERIC_N_M = "^[A-Za-z0-9]{n,m}$";
    public static final String ALPHA_NUMERIC_PA = "^[A-Za-z][A-Za-z0-9]*$";
    public static final String ALPHA_NUMERIC_PA_N_M = "^[A-Za-z][A-Za-z0-9]{n,m}$";
    public static final String ALPHA_NUMERIC_UL = "^[A-Za-z0-9_]+$";
    public static final String ALPHA_NUMERIC_UL_PA = "^[A-Za-z_][A-Za-z0-9_]*$";
    public static final String ALPHA_NUMERIC_UL_DL_PA = "^[A-Za-z_\\$][A-Za-z0-9_\\$]*$";
    public static final String ALPHA_NUMERIC_DOT = "^[A-Za-z0-9\\.]+$";
    public static final String ALPHA_NUMERIC_URL = "^[A-Za-z0-9\\.\\-_~]+$";
    public static final String ALPHABAT_DOUBLE = "^[^x00-xff]+$";
    public static final String CHINESE = "^[\u4e00-\u9fa5]+$";
    public static final String CHINESE_ALPHA_NUMERIC = "^[\u4e00-\u9fa5A-Za-z0-9]+$";
    public static final String HEX = "^[A-Fa-f0-9]+$";
    public static final String MD5 = "^[A-Fa-f0-9]{32}$";
    public static final String USER_CODE = "^[a-zA-Z0-9\\u4e00-\\u9fa5][._\\-`~!@#$%a-zA-Z0-9\\u4e00-\\u9fa5]{1,15}$";
    public static final String USER_PASS = "^(?:(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9])|(?=.*[A-Z])(?=.*[a-z])(?=.*[._\\-`~!@#$%])|(?=.*[A-Z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])|(?=.*[a-z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])).{6,16}$";
    public static final String MOBILE = "^((\\+86)|(86)|)?(13[0-9]|14[5-9]|15[0|1|2|3|5|6|7|8|9]|166|17[0-8]|18[0-9]|19[1|8|9])\\d{8}$";
    public static final String MOBILE_11 = "^(13[0-9]|14[5-9]|15[0|1|2|3|5|6|7|8|9]|166|17[0-8]|18[0-9]|19[1|8|9])\\d{8}$";
    public static final String IP = "^((?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\.){3}(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])$";
    public static final String MAC = "^[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}$";
    public static final String QQ = "^[1-9]\\d{4,10}$";
    public static final String POSTAL_CODE = "^[1-9]\\d{5}$";
    public static final String EMAIL = "^([\\w-_]+(?:\\.[\\w-_]+)*)@((?:[a-z0-9]+(?:-[a-zA-Z0-9]+)*)+\\.[a-z]{2,6})$";
    public static final String FILE_NAME = "(?!((^(?i)con$)|(^(?i)con\\..*)|(^(?i)prn$)|(^(?i)prn\\..*)|(^(?i)aux$)|(^(?i)aux\\..)|(^(?i)nul$)|(^(?i)nul\\..*)|(^(?i)com[0-9]$)|(^(?i)com[0-9]\\..*)|(^(?i)lpt[0-9]$)|(^(?i)lpt[0-9]\\..*)|(^\\s+)|(.*\\s$)|(^\\.$)))(^[^\\\\/\\:\\*\\?\\\"\\<\\>\\|]{1,255}$)";
    public static final String DATE = "^(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$";
    public static final String TIME = "^([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9])$";
    public static final String DATE_TIME = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))\\s(([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9]))$";
    public static final String IDCARD = "^(\\d{6})((((19|20)[0-9]{2})(((0[13578]|1[02])(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))(\\d{3}[0-9xX*])$";
    public static final String SYMBOLS_UNICODE = "[\u2300-\u23ff]|[\u2600-\u27ff]|[\u2b00-\u2bff]|[\ufe00-\ufe0f]";
    public static final String SYMBOLS_EMOJI_IOS = "[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\ud83e\udc00-\ud83e\udfff]|[\ud800\udc00-\udbff\udfff]";
    public static final String SYMBOLS_ALL = "[\u2300-\u23ff]|[\u2600-\u27ff]|[\u2b00-\u2bff]|[\ufe00-\ufe0f]|[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\ud83e\udc00-\ud83e\udfff]|[\ud800\udc00-\udbff\udfff]";
    public static final String IS_REGEXP = "isRegexp";
    public static final String IS_NUMERIC = "isNumeric";
    public static final String IS_NUMERIC_LEN = "isNumericLen";
    public static final String IS_INTEGER = "isInteger";
    public static final String IS_INTEGER_VALUE = "isIntegerValue";
    public static final String IS_ALPHA_NUMERIC = "isAlphaNumeric";
    public static final String IS_ALPHA_NUMERIC_LEN = "isAlphaNumericLen";
    public static final String IS_ALPHA_NUMERIC_PA_LEN = "isAlphaNumericPALen";
    public static final String IS_ALPHA_NUMERIC_UL_LEN = "isAlphaNumericULLen";
    public static final String IS_ALPHA_NUMERIC_UL_PA_LEN = "isAlphaNumericULPALen";
    public static final String IS_ALPHA_NUMERIC_DOT_LEN = "isAlphaNumericDotLen";
    public static final String IS_ALPHA_NUMERIC_URL_LEN = "isAlphaNumericUrlLen";
    public static final String IS_FLOAT = "isFloat";
    public static final String IS_AMOUNT_2R = "isAmount2R";
    public static final String IS_EMAIL = "isEmail";
    public static final String IS_POSTAL_CODE = "isPostalCode";
    public static final String IS_IP = "isIP";
    public static final String IS_MAC = "isMacAddress";
    public static final String IS_MOBILE = "isMsisdn";
    public static final String IS_MOBILE11 = "isMsisdn11";
    public static final String IS_DATE = "isDate";
    public static final String IS_TIME = "isTime";
    public static final String IS_DATE_TIME = "isDateTime";
    public static final String IS_IDCARD = "isIdcard";
    public static final String IS_USER_CODE = "isUserCode";
    public static final String IS_USER_PASS = "isUserPass";
    public static final String IS_EMPTY = "isEmpty";
    public static final String IS_NOT_EMPTY = "isNotEmpty";
    public static final String IS_EQUAL = "isEqual";
    public static final String IS_SCOPE = "isScope";
    public static final String IS_SELECT = "isSelect";
    public static final String IS_CHECKED = "isChecked";
    public static final String IS_LEN = "isLen";
    public static final String IS_BYTE_LEN = "isByteLen";
    public static final String IS_LESS_THEN = "isLessThen";
    public static final String IS_LESS_THEN_VALUE = "isLessThenValue";
    public static final String IS_LESS_EQUAL_THEN = "isLessEqualThen";
    public static final String IS_LESS_EQUAL_THEN_VALUE = "isLessEqualThenValue";
    public static final String IS_GREATER_THEN = "isGreaterThen";
    public static final String IS_GREATER_THEN_VALUE = "isGreaterThenValue";
    public static final String IS_GREATER_EQUAL_THEN = "isGreaterEqualThen";
    public static final String IS_GREATER_EQUAL_THEN_VALUE = "isGreaterEqualThenValue";
}

