/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.zhiqim.kernel.config.Config;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.config.ItemType;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.util.Strings;

public class Group
implements Serializable,
ZhiqimConstants,
SignConstants {
    private static final long serialVersionUID = 1L;
    private Config config;
    private String id;
    private String desc;
    private char symbol;
    private LinkedMapSV<Item> itemMap = new LinkedMapSV();

    public Group(String id) {
        this(null, id, null);
    }

    public Group(Config config, String id, String desc) {
        this(config, id, desc, '#');
    }

    public Group(Config config, String id, String desc, char symbol) {
        this.config = config;
        this.id = id;
        this.desc = desc;
        this.symbol = symbol;
    }

    public String ignoreCase(String value) {
        return this.config != null && this.config.isIgnoreCase() ? value.toLowerCase() : value;
    }

    public Group clone() {
        Group newGroup = new Group(this.config, this.id, this.desc, this.symbol);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            newGroup.add(((Item)entry.getValue()).clone().setGroup(newGroup));
        }
        return newGroup;
    }

    public String toString() {
        if (this.isXml()) {
            StringBuilder strb = new StringBuilder("    ").append("<group").append(" id=").append('\"').append(this.id).append('\"').append(" desc=").append('\"').append(this.desc).append('\"').append(">").append("\r\n");
            for (Item item : this.itemMap.values()) {
                strb.append("    ").append("    ").append(item).append("\r\n");
            }
            strb.append("    ").append("</group>");
            return strb.toString();
        }
        StringBuilder strb = new StringBuilder();
        if (this.desc != null) {
            strb.append(this.symbol).append(this.desc).append("\r\n");
        }
        strb.append("[").append(this.id).append("]").append("\r\n");
        for (Item item : this.itemMap.values()) {
            strb.append(item).append("\r\n");
        }
        return strb.toString();
    }

    public Group setId(String id) {
        this.id = id;
        return this;
    }

    public boolean add(String key, String value) {
        return this.add(new Item(this, key, value, ItemType.PROTECTED, null));
    }

    public boolean add(String key, Object value) {
        return this.add(key, Strings.valueOf(value));
    }

    public boolean add(String key, String value, ItemType type, String desc) {
        return this.add(new Item(this, key, value, type, desc));
    }

    public boolean add(String key, String value, ItemType type, String desc, char symbol) {
        return this.add(new Item(this, key, value, type, desc, symbol));
    }

    public boolean add(Item item) {
        String keyCase = this.ignoreCase(item.getKey());
        if (this.itemMap.containsKey(keyCase)) {
            return false;
        }
        this.itemMap.put(keyCase, item);
        return true;
    }

    public boolean remove(String key) {
        return this.itemMap.remove(this.ignoreCase(key)) != null;
    }

    public String getId() {
        return this.id;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    public int size() {
        return this.itemMap.size();
    }

    public Collection<Item> list() {
        return this.itemMap.values();
    }

    public LinkedMapSV<Item> map() {
        return this.itemMap;
    }

    public boolean hasItem(String key) {
        return this.itemMap.containsKey(this.ignoreCase(key));
    }

    public Item item(String key) {
        return (Item)this.itemMap.get(this.ignoreCase(key));
    }

    public String getString(String key) {
        Item item = this.item(key);
        return item == null ? null : item.getString();
    }

    public String getString(String key, String defaultValue) {
        Item item = this.item(key);
        return item == null ? defaultValue : item.getString(defaultValue);
    }

    public int getInt(String key) {
        Item item = this.item(key);
        return item == null ? -1 : item.getInt();
    }

    public int getInt(String key, int defaultValue) {
        Item item = this.item(key);
        return item == null ? defaultValue : item.getInt(defaultValue);
    }

    public long getLong(String key) {
        Item item = this.item(key);
        return item == null ? -1L : item.getLong();
    }

    public long getLong(String key, long defaultValue) {
        Item item = this.item(key);
        return item == null ? defaultValue : item.getLong(defaultValue);
    }

    public boolean isTrue(String key) {
        Item item = this.item(key);
        return item == null ? false : item.isTrue();
    }

    public boolean isTrue(String key, boolean defaultValue) {
        Item item = this.item(key);
        return item == null ? defaultValue : item.isTrue();
    }

    public String getName() {
        return this.config == null ? null : this.config.getName();
    }

    public String getPath() {
        return this.config == null ? null : this.config.getPath();
    }

    public boolean isXml() {
        return this.config != null && this.config.isXml();
    }

    public boolean isIni() {
        return this.config == null || this.config.isIni();
    }

    public boolean isIgnoreCase() {
        return this.config != null && this.config.isIgnoreCase();
    }

    public boolean isPrivate() {
        return !this.isPrivateNot();
    }

    public boolean isPrivateNot() {
        for (Item item : this.itemMap.values()) {
            if (item.isPrivate()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

