/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.control.Threadx;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Threads;

final class ZhiqimMonitor
extends Threadx
implements ZhiqimConstants,
SignConstants {
    private static final Log logger = LogFactory.getLog(ZhiqimMonitor.class);
    private ServerSocket serverSocket;
    private int port;

    ZhiqimMonitor(int port) {
        this.port = port;
    }

    @Override
    protected String getThreadName() {
        return "ZhiqimMonitor";
    }

    @Override
    protected boolean openBefore() {
        try {
            this.serverSocket = new ServerSocket(this.port, 5, InetAddress.getByName("127.0.0.1"));
            this.serverSocket.setReuseAddress(true);
            return true;
        }
        catch (BindException bindException) {
            logger.error("\u542f\u52a8\u76d1\u89c6\u7ebf\u7a0b\u5931\u8d25\uff0c\u5de5\u7a0b\u5df2\u542f\u52a8\u6216\u7aef\u53e3[boot.port]\u88ab\u5360\u7528");
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"\u542f\u52a8\u76d1\u89c6\u7ebf\u7a0b\u5931\u8d25", (Throwable)e, new Object[0]);
            return false;
        }
    }

    @Override
    protected void closeAfter() {
        Threads.closeIgnoreException(this.serverSocket);
    }

    @Override
    public void loop() {
        Socket socket = null;
        String cmd = null;
        try {
            socket = this.serverSocket.accept();
            LineNumberReader line = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
            String lineKey = line.readLine();
            if (!"zhiqim".equals(lineKey)) {
                return;
            }
            try {
                cmd = line.readLine();
                if ("info".equals(cmd)) {
                    StringBuilder strb = new StringBuilder().append("\u54cd\u5e94\u7ed3\u679c:").append("\r\n").append("PID:").append(Systems.getPid()).append("\r\n");
                    socket.getOutputStream().write(Strings.getBytesUTF8(strb.toString()));
                    socket.getOutputStream().flush();
                } else if ("test".equals(cmd) || "reload".equals(cmd)) {
                    StringBuilder strb = new StringBuilder().append("\u54cd\u5e94\u7ed3\u679c:").append("\r\n").append("\u6682\u672a\u5b9e\u73b0").append("\r\n");
                    socket.getOutputStream().write(Strings.getBytesUTF8(strb.toString()));
                    socket.getOutputStream().flush();
                } else if ("help".equals(cmd) || "?".equals(cmd)) {
                    StringBuilder strb = new StringBuilder().append("\u54cd\u5e94\u7ed3\u679c:").append("\r\n").append("-s    \u542f\u52a8\u5de5\u7a0b").append("\r\n").append("-c    \u5173\u95ed\u5de5\u7a0b").append("\r\n").append("-i    \u67e5\u770b\u4fe1\u606f").append("\r\n").append("-t    \u6d4b\u8bd5\u914d\u7f6e\u6587\u4ef6").append("\r\n").append("-r    \u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e").append("\r\n").append("-h    \u5e2e\u52a9").append("\r\n").append("-?    \u5e2e\u52a9").append("\r\n");
                    socket.getOutputStream().write(Strings.getBytesUTF8(strb.toString()));
                    socket.getOutputStream().flush();
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        finally {
            Threads.closeIgnoreException(socket);
            if ("close".equals(cmd)) {
                this.closeNotInterrupt();
                System.exit(0);
            }
        }
    }
}

