/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.javax;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.sqlite.jdbc4.JDBC4PooledConnection;

public class SQLitePooledConnection
extends JDBC4PooledConnection
implements PooledConnection {
    protected Connection physicalConn;
    protected volatile Connection handleConn;
    protected List<ConnectionEventListener> listeners = new ArrayList<ConnectionEventListener>();

    protected SQLitePooledConnection(Connection physicalConn) {
        this.physicalConn = physicalConn;
    }

    @Override
    public void close() throws SQLException {
        if (this.handleConn != null) {
            this.listeners.clear();
            this.handleConn.close();
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
            }
            finally {
                this.physicalConn = null;
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.handleConn != null) {
            this.handleConn.close();
        }
        this.handleConn = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){
            boolean isClosed;

            /*
             * Unable to fully structure code
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                block11: {
                    block10: {
                        name = method.getName();
                        if (!"close".equals(name)) break block10;
                        event = new ConnectionEvent(SQLitePooledConnection.this);
                        i = SQLitePooledConnection.this.listeners.size() - 1;
                        while (i >= 0) {
                            SQLitePooledConnection.this.listeners.get(i).connectionClosed(event);
                            --i;
                        }
                        if (!SQLitePooledConnection.this.physicalConn.getAutoCommit()) {
                            SQLitePooledConnection.this.physicalConn.rollback();
                        }
                        SQLitePooledConnection.this.physicalConn.setAutoCommit(true);
                        this.isClosed = true;
                        return null;
                    }
                    try {
                        if ("isClosed".equals(name)) {
                            if (!this.isClosed) {
                                this.isClosed = (Boolean)method.invoke((Object)SQLitePooledConnection.this.physicalConn, args);
                            }
                            return this.isClosed;
                        }
                        if (this.isClosed) {
                            throw new SQLException("Connection is closed");
                        }
                        return method.invoke((Object)SQLitePooledConnection.this.physicalConn, args);
                    }
                    catch (SQLException e) {
                        if (!"database connection closed".equals(e.getMessage())) break block11;
                        event = new ConnectionEvent(SQLitePooledConnection.this, e);
                        i = SQLitePooledConnection.this.listeners.size() - 1;
                        ** while (i >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        SQLitePooledConnection.this.listeners.get(i).connectionErrorOccurred(event);
                        --i;
                        continue;
                    }
                }
                throw e;
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
            }
        });
        return this.handleConn;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }
}

