/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;

public class ConnStrategy {
    static final boolean DEBUG = false;
    private boolean optFound = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    private Properties socketOptions = new Properties();
    public Vector cOpts = new Vector(10, 10);

    public ConnStrategy(Properties properties) {
        this.createSocketOptions(properties);
    }

    public void addOption(ConnOption connOption) {
        this.cOpts.addElement(connOption);
    }

    public void addSocketOptions(boolean bl) {
        if (bl) {
            ((Hashtable)this.socketOptions).put(new Integer(1), "YES");
        } else {
            ((Hashtable)this.socketOptions).put(new Integer(1), "NO");
        }
    }

    public void clearElements() {
        this.cOpts.removeAllElements();
    }

    public void createSocketOptions(Properties properties) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase("TCP.NODELAY")) continue;
            bl = true;
            string2 = properties.getProperty("TCP.NODELAY").toUpperCase();
            if (string2.equals("NO")) {
                ((Hashtable)this.socketOptions).put(new Integer(0), "NO");
                break;
            }
            ((Hashtable)this.socketOptions).put(new Integer(0), "YES");
            break;
        }
        if (!bl) {
            ((Hashtable)this.socketOptions).put(new Integer(0), "YES");
        }
    }

    public ConnOption execute() throws NetException {
        while (this.nextOptToTry < this.cOpts.size()) {
            try {
                this.copt = (ConnOption)this.cOpts.elementAt(this.nextOptToTry);
                this.copt.connect(this.socketOptions);
                this.copt.sdu = this.sdu;
                this.copt.tdu = this.tdu;
                this.optFound = true;
                ++this.nextOptToTry;
                return this.copt;
            }
            catch (IOException iOException) {
                ++this.nextOptToTry;
            }
        }
        throw new NetException(20);
    }

    public ConnOption getOption() {
        return this.copt;
    }

    public boolean hasMoreOptions() {
        return this.nextOptToTry < this.cOpts.size();
    }

    public boolean optAvailable() {
        return this.optFound;
    }
}

