/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.codes;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Hexs;

public class SHA1
implements CodeConstants {
    public static String encodeUTF8(String src) {
        return SHA1.encode(src, _UTF_8_C_);
    }

    public static String encode(String src, String encoding) {
        byte[] destBytes = SHA1.encodeByte(src, encoding);
        return Hexs.toHexString(destBytes);
    }

    public static String encode(String src, Charset charset) {
        byte[] destBytes = SHA1.encodeByte(src, charset);
        return Hexs.toHexString(destBytes);
    }

    public static byte[] encodeByte(String src, String encoding) {
        Asserts.notNull(src, "src");
        Asserts.notNull(encoding, "encoding");
        try {
            return SHA1.encodeByte(src.getBytes(encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Asserts.exception("\u975e\u6cd5\u7684\u7f16\u7801");
        }
    }

    public static byte[] encodeByte(String src, Charset charset) {
        Asserts.notNull(src, "src");
        Asserts.notNull(charset, "charset");
        return SHA1.encodeByte(src.getBytes(charset));
    }

    public static byte[] encodeByte(byte[] src) {
        Asserts.notNull(src, "src");
        return SHA1.getInstance().digest(src);
    }

    public static MessageDigest getInstance() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (Exception exception) {
            throw Asserts.exception("JDK\u4e0d\u652f\u6301[SHA1]\u7b97\u6cd5");
        }
    }
}

