/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.tree;

import java.lang.reflect.Field;
import org.zhiqim.kernel.tree.Treer;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Validates;

public class TreeFielder<E>
implements Treer<E> {
    private String pFieldName;
    private String sFieldName;

    public TreeFielder(String pFieldName, String sFieldName) {
        this.pFieldName = pFieldName;
        this.sFieldName = sFieldName;
    }

    @Override
    public boolean isChildNode(E parent, E child) {
        try {
            Field pField = Classes.getFieldDeep(parent.getClass(), this.sFieldName);
            Field sField = Classes.getFieldDeep(child.getClass(), this.pFieldName);
            pField.setAccessible(true);
            sField.setAccessible(true);
            Object pValue = pField.get(parent);
            Object sValue = sField.get(child);
            Asserts.as((String)(pValue != null && sValue != null ? null : "[\u6811\u578b\u83dc\u5355]\u7f16\u53f7\u548c\u7236\u7f16\u53f7\u5b57\u6bb5\u503c\u4e0d\u5141\u8bb8\u4e3anull"));
            return Validates.isEqual(pValue, sValue);
        }
        catch (Exception e) {
            throw Asserts.exception("[\u6811\u578b\u83dc\u5355]" + e.getMessage());
        }
    }
}

