/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging.adapter;

import java.util.logging.Level;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogAdapter;
import org.zhiqim.kernel.logging.Logger;

public class Jdk14Logger
implements LogAdapter,
Logger {
    @Override
    public boolean adapter() {
        return true;
    }

    @Override
    public void logger(Log log, int level, String message, Throwable throwable) {
        Level jdk14Level = this.getLevel(level);
        java.util.logging.Logger jdk14Log = java.util.logging.Logger.getLogger(log.getParamName());
        jdk14Log.log(jdk14Level, message, throwable);
    }

    @Override
    public boolean isLoggerEnabled(Log log, int level) {
        Level jdk14Level = this.getLevel(level);
        java.util.logging.Logger jdk14Log = java.util.logging.Logger.getLogger(log.getParamName());
        return jdk14Log.isLoggable(jdk14Level);
    }

    private Level getLevel(int level) {
        switch (level) {
            case 1: {
                return Level.FINE;
            }
            case 2: {
                return Level.INFO;
            }
        }
        return Level.SEVERE;
    }
}

