/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.extend;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.extend.HashMapCO;
import org.zhiqim.kernel.extend.MapCO;
import org.zhiqim.kernel.util.Asserts;

@AnAlias(value={"LinkedMapCO"})
@AnNew
public class LinkedMapCO
extends HashMapCO {
    private final LinkedHashMap<Class<?>, Object> instance;

    public LinkedMapCO() {
        this.instance = new LinkedHashMap();
    }

    public LinkedMapCO(int count) {
        this.instance = new LinkedHashMap(count);
    }

    public LinkedMapCO(int initialCapacity, float loadFactor, boolean accessOrder) {
        this.instance = new LinkedHashMap(initialCapacity, loadFactor, accessOrder);
    }

    public LinkedMapCO(Class<?> key, Object value) {
        this.instance = new LinkedHashMap(1);
        this.instance.put(key, value);
    }

    public LinkedMapCO(Map<Class<?>, Object> instance) {
        this.instance = new LinkedHashMap(instance);
    }

    public LinkedMapCO(MapCO instance) {
        this.instance = new LinkedHashMap(instance.instance());
    }

    public Object[] toArray() {
        return this.instance.values().toArray();
    }

    public Object get(int index) {
        Asserts.asserts(index >= 0, ZhiqimI18n.indexMustBeGreaterThanOrEqualZero);
        if (index >= this.instance.size()) {
            return null;
        }
        Set<Map.Entry<Class<?>, Object>> entrySet = this.instance.entrySet();
        Iterator<Map.Entry<Class<?>, Object>> it = entrySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<Class<?>, Object> entry = it.next();
            if (index <= i) {
                if (index != i) break;
                return entry.getValue();
            }
            ++i;
        }
        return null;
    }
}

