/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.config;

import java.io.Serializable;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.ItemType;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.xml.Xmlx;

public class Item
implements Serializable,
ZhiqimConstants,
SignConstants {
    private static final long serialVersionUID = 1L;
    private Group group;
    private String key;
    private String value;
    private ItemType type;
    private String desc;
    private char symbol;

    public Item(Group group, String key, String value, ItemType type, String desc) {
        this(group, key, value, type, desc, '#');
    }

    public Item(Group group, String key, String value, ItemType type, String desc, char symbol) {
        this.group = group;
        this.key = key;
        this.value = group.isXml() ? Xmlx.toXmlLoad(value) : value;
        this.type = type;
        this.desc = desc;
        this.symbol = symbol;
    }

    public Item clone() {
        return new Item(this.group, this.key, this.value, this.type, this.desc, this.symbol);
    }

    public String toString() {
        if (this.group.isXml()) {
            return "<item" + " key=" + '\"' + this.key + '\"' + " value=" + '\"' + Xmlx.toXmlSave(this.value) + '\"' + " type=" + '\"' + ItemType.toString(this.type) + '\"' + " desc=" + '\"' + this.desc + '\"' + " />";
        }
        StringBuilder strb = new StringBuilder();
        if (this.type != null || this.desc != null) {
            strb.append(this.symbol);
            if (this.type != null) {
                strb.append((Object)this.type);
            }
            if (this.desc != null) {
                strb.append(this.desc);
            }
            strb.append("\r\n");
        }
        strb.append(this.key).append("=").append(this.value);
        return strb.toString();
    }

    public Item setValue(String value) {
        this.value = value;
        return this;
    }

    public Item setGroup(Group group) {
        this.group = group;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public ItemType getType() {
        return this.type;
    }

    public String getTypeString() {
        return ItemType.toString(this.type);
    }

    public boolean isPublic() {
        return ItemType.PUBLIC == this.type;
    }

    public boolean isProtected() {
        return ItemType.PROTECTED == this.type;
    }

    public boolean isPrivate() {
        return ItemType.PRIVATE == this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getString() {
        return this.value;
    }

    public String getString(String defaultValue) {
        return Validates.isEmptyBlank(this.value) ? defaultValue : this.value;
    }

    public String getStringFormat() {
        return Xmlx.toXmlSave(this.value);
    }

    public int getInt() {
        return Ints.toInt(this.value);
    }

    public int getInt(int defaultValue) {
        return Ints.toInt(this.value, defaultValue);
    }

    public long getLong() {
        return Longs.toLong(this.value);
    }

    public long getLong(long defaultValue) {
        return Longs.toLong(this.value, defaultValue);
    }

    public boolean isTrue() {
        return "true".equalsIgnoreCase(this.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

