/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.statement;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Statement;
import org.zhiqim.zml.StatementNesting;
import org.zhiqim.zml.StatementParser;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.StatementException;
import org.zhiqim.zml.statement._Return;

public class _Function
extends Statement
implements StatementNesting {
    private String name;
    private String path;
    private ArrayList<String> variableNameList;
    private List<Statement> stmtList;
    private boolean isBeginExclusiveLine;
    private transient String content;
    private transient int contentBeginIndex;

    public _Function() {
        this.variableNameList = new ArrayList();
    }

    public _Function(String path) {
        this.path = path;
        this.variableNameList = new ArrayList();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isNesting() {
        return true;
    }

    @Override
    public boolean isExclusiveLine() throws StatementException {
        return super.isExclusiveLine() ? this.isBeginExclusiveLine : false;
    }

    @Override
    public void parseStatement() throws StatementException {
        String s = Strings.trim((String)this.getStatement(), (String)"<#function ", (String)"</#function>");
        int ind = s.indexOf(">");
        if (ind == -1) {
            throw new StatementException(this, "<#function>\u672a\u627e\u5230\u5355\u884c\u7ed3\u675f\u7b26");
        }
        String expression = Strings.formatSpace((String)s.substring(0, ind));
        int indName = expression.indexOf("(");
        if (indName == -1) {
            throw new StatementException(this, "<#function>\u672a\u627e\u5230\u51fd\u6570\u540d");
        }
        this.name = expression.substring(0, indName).trim();
        String params = expression.substring(indName).trim();
        if (!Validates.isEmpty((String)(params = Strings.trim((String)Strings.trim((String)params, (String)"(", (String)")"))))) {
            String[] paramArr;
            String[] stringArray = paramArr = params.split(",");
            int n = paramArr.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                this.variableNameList.add(param.trim());
                ++n2;
            }
            this.variableNameList.trimToSize();
        }
        this.content = s.substring(ind + 1);
        int brNum = Strings.getStartsWithBrNum((String)this.content);
        if (brNum > 0) {
            this.content = this.content.substring(brNum);
        }
        this.isBeginExclusiveLine = brNum > 0;
        this.contentBeginIndex = this.getBeginIndex() + "<#function ".length() + ind + 1 + brNum;
        this.content = Strings.removeRightMaybeEmptyBlankLine((String)this.content);
        this.stmtList = StatementParser.parseStatementNesting(this);
        this.content = null;
    }

    @Override
    public String process(ZmlVariable variableMap) throws StatementException {
        variableMap.addFunction(this);
        return null;
    }

    public Object build(ZmlVariable variableMap) throws StatementException {
        StringBuilder strb = new StringBuilder();
        try {
            StatementParser.processStatementList(this.stmtList, variableMap, strb);
            return strb.toString();
        }
        catch (_Return.ReturnException e) {
            return e.hasValue() ? e.getValue() : strb.toString();
        }
    }

    public String getName() {
        return this.name;
    }

    public List<String> getVariableNameList() {
        return this.variableNameList;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public int getContentBeginIndex() {
        return this.contentBeginIndex;
    }

    @Override
    public String getPrevStatement(Statement stmt) throws StatementException {
        int ind = this.stmtList.indexOf(stmt);
        if (ind <= 0) {
            return null;
        }
        return this.stmtList.get(ind - 1).getStatement();
    }

    @Override
    public String getNextStatement(Statement stmt) throws StatementException {
        int ind = this.stmtList.indexOf(stmt);
        if (ind == -1 || ind >= this.stmtList.size() - 1) {
            return null;
        }
        return this.stmtList.get(ind + 1).getStatement();
    }
}

