/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.dbo.defined;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.defined._ViewField;
import org.zhiqim.orm.dbo.defined._ViewJoin;

public class _View
implements ORMConstants,
Dbo {
    private String name;
    private String table;
    private LinkedMapSV<_ViewField> fieldMap = new LinkedMapSV();
    private List<_ViewJoin> joinList = new ArrayList<_ViewJoin>();

    public _View(String name, String table) {
        this.name = name;
        this.table = table;
    }

    public void addField(String name, String table, String column, int type) {
        _ViewField field = new _ViewField(name, table, column.toUpperCase(), type);
        this.fieldMap.put(name, (Object)field);
    }

    public void addJoin(String type, String lTable, String lColumn, String rTable, String rColumn, String rValue) {
        if (Validates.isNotEmpty((String)rColumn)) {
            rColumn = rColumn.toUpperCase();
        }
        _ViewJoin join = new _ViewJoin(type, lTable, lColumn.toUpperCase(), rTable, rColumn, rValue);
        this.joinList.add(join);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder("    ").append("<view").append(" name=").append('\"').append(this.name).append('\"').append(" table=").append('\"').append(this.table).append('\"').append(">").append("\r\n");
        for (_ViewField field : this.fieldMap.values()) {
            strb.append("    ").append("    ").append(field).append("\r\n");
        }
        strb.append("\r\n");
        for (_ViewJoin where : this.joinList) {
            strb.append("    ").append("    ").append(where).append("\r\n");
        }
        strb.append("    ").append("</view>");
        return strb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<_ViewJoin> getWhereList() {
        return this.joinList;
    }

    public String[] getTableArr() {
        return Arrays.toStringArray((String)this.table, (String)",");
    }

    public List<String> getTableNoAliasList() {
        String[] tableArr;
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = tableArr = this.getTableArr();
        int n = tableArr.length;
        int n2 = 0;
        while (n2 < n) {
            String table = stringArray[n2];
            String[] alias = Arrays.toStringArray((String)table, (String)" ");
            if (alias.length == 2) {
                list.add(alias[0]);
            } else {
                list.add(table);
            }
            ++n2;
        }
        return Lists.trim(list);
    }

    public String getTableName(String tableName) {
        String[] tableArr;
        String[] stringArray = tableArr = this.getTableArr();
        int n = tableArr.length;
        int n2 = 0;
        while (n2 < n) {
            String table = stringArray[n2];
            String[] alias = Arrays.toStringArray((String)table, (String)" ");
            if (alias.length == 2 && tableName.equals(alias[1])) {
                return alias[0];
            }
            ++n2;
        }
        return tableName;
    }

    public List<_ViewField> getFieldList(String fields) {
        if (Validates.isEmptyBlank((String)fields)) {
            return new ArrayList<_ViewField>(this.fieldMap.values());
        }
        List fieldNameList = Lists.toStringList((String)fields);
        ArrayList<_ViewField> fieldList = new ArrayList<_ViewField>();
        for (_ViewField field : this.fieldMap.values()) {
            if (!fieldNameList.contains(field.getField())) continue;
            fieldList.add(field);
        }
        Asserts.as(!fieldList.isEmpty() ? null : "[" + fields + "]\u672a\u627e\u5230\u4e00\u4e2a\u5339\u914d\u7684\u5b57\u6bb5");
        return fieldList;
    }

    @Override
    public String getGetMethod(String name) {
        _ViewField field = (_ViewField)this.fieldMap.get(name);
        if (field == null) {
            return null;
        }
        return field.getGetMethod();
    }

    public String getSetMethod(String name) {
        _ViewField field = (_ViewField)this.fieldMap.get(name);
        if (field == null) {
            return null;
        }
        return field.getSetMethod();
    }

    @Override
    public _ViewField getField(String field) {
        return (_ViewField)this.fieldMap.get(field);
    }

    @Override
    public String getColumn(String field) {
        _ViewField _viewField = (_ViewField)this.fieldMap.get(field);
        if (_viewField == null) {
            return null;
        }
        return String.valueOf(_viewField.getTable()) + "." + _viewField.getColumn();
    }

    @Override
    public boolean hasField(String field) {
        return this.fieldMap.containsKey(field);
    }

    public boolean hasAllField(String[] fieldArr) {
        String[] stringArray = fieldArr;
        int n = fieldArr.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (!this.fieldMap.containsKey(field)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getDefaultFieldSQL(String fields) {
        StringBuilder strb = new StringBuilder();
        List<_ViewField> fieldList = this.getFieldList(fields);
        _ViewField field = fieldList.get(0);
        strb.append(field.getTable()).append(".").append(field.getColumn()).append(" as ").append(field.getField());
        int i = 1;
        while (i < fieldList.size()) {
            field = fieldList.get(i);
            strb.append(", ").append(field.getTable()).append(".").append(field.getColumn()).append(" as ").append(field.getField());
            ++i;
        }
        return strb.toString();
    }

    @Override
    public boolean hasEqualJoin() {
        for (_ViewJoin join : this.joinList) {
            if (!"EQUAL".equals(join.getType())) continue;
            return true;
        }
        return false;
    }

    public _ViewField[] getFieldColumnListOrderByLen() {
        _ViewField[] array = new _ViewField[this.fieldMap.size()];
        int index = 0;
        for (_ViewField field : this.fieldMap.values()) {
            array[index++] = field;
        }
        int i = 0;
        while (i < array.length) {
            int j = i + 1;
            while (j < array.length) {
                if (array[i].getField().length() < array[j].getField().length()) {
                    _ViewField v = array[i];
                    array[i] = array[j];
                    array[j] = v;
                }
                ++j;
            }
            ++i;
        }
        return array;
    }

    public String getEqualJoinSQL() {
        StringBuilder strb = new StringBuilder();
        boolean isFirst = true;
        for (_ViewJoin join : this.joinList) {
            if (!"EQUAL".equals(join.getType())) continue;
            if (!isFirst) {
                strb.append(" and ");
            } else {
                strb.append(" where ");
                isFirst = false;
            }
            strb.append(join.getLTable()).append(".").append(join.getLColumn());
            strb.append(" = ");
            if (Validates.isEmptyBlank((String)join.getRValue())) {
                strb.append(join.getRTable()).append(".").append(join.getRColumn());
                continue;
            }
            strb.append("'").append(join.getRValue()).append("'");
        }
        return strb.toString();
    }

    public String getJoinTable(ZTable fTable, Selector selector, MapSO paramMap) throws ORMException {
        HashMapSS tableos = new HashMapSS();
        HashMapSS tables = new HashMapSS();
        HashMapSS tableas = new HashMapSS();
        String[] tableArray = this.getTableArr();
        int i = 0;
        while (i < tableArray.length) {
            String table = tableArray[i].trim();
            int ind = table.indexOf(" ");
            if (ind == -1) {
                tables.put(table, table);
                tableos.put(table, table);
                tableas.put(table, table);
            } else {
                String alias = table.substring(ind + 1).trim();
                tables.put(alias, table);
                tableos.put(alias, table);
                tableas.put(alias, table.substring(0, ind));
            }
            ++i;
        }
        HashMapSS joinMap = new HashMapSS();
        int i2 = 0;
        while (i2 < this.joinList.size()) {
            _ViewJoin join = this.joinList.get(i2);
            if (!"EQUAL".equals(join.getType())) {
                String joinType = "LEFT".equals(join.getType()) ? " left join " : " right join ";
                String lTable = join.getLTable();
                String laTable = tables.get(lTable);
                String rTable = join.getRTable();
                String rrTable = tableas.get(rTable);
                String raTable = tables.get(rTable);
                raTable = selector.getJoinWhereSQL(fTable, rTable, rrTable, raTable, paramMap);
                StringBuilder joinSql = null;
                if (joinMap.containsKey(String.valueOf(lTable) + "," + rTable)) {
                    joinSql = new StringBuilder(joinMap.get(String.valueOf(lTable) + "," + rTable));
                    joinSql.append(" and ");
                } else {
                    joinSql = new StringBuilder();
                    joinSql.append(laTable).append(joinType).append(raTable).append(" on ");
                }
                joinSql.append(join.getLTable()).append(".").append(join.getLColumn());
                joinSql.append(" = ");
                if (Validates.isEmptyBlank((String)join.getRValue())) {
                    joinSql.append(join.getRTable()).append(".").append(join.getRColumn()).append(" ");
                } else {
                    joinSql.append("'").append(join.getRValue()).append("' ");
                }
                joinMap.put(String.valueOf(lTable) + "," + rTable, joinSql.toString());
            }
            ++i2;
        }
        for (Map.Entry entry : joinMap.entrySet()) {
            String tableKey = (String)entry.getKey();
            String joinSql = (String)entry.getValue();
            String[] tableArr = tableKey.split(",");
            String lTable = tableArr[0];
            String rTable = tableArr[1];
            tables.remove(rTable);
            String laTable = tableos.get(lTable);
            String lTableValue = tables.get(lTable);
            if (lTableValue == null) {
                throw new ORMException("\u6682\u4e0d\u652f\u6301\u5d4c\u5957\u5de6\u53f3\u8fde\u63a5,\u8bf7\u8c03\u6574\u4e3a\u4ee5\u4e00\u5f20\u8868\u4e3a\u4e3b\u8868\u8fdb\u884c\u5de6\u53f3\u8fde\u63a5");
            }
            lTableValue = lTableValue.replaceAll(String.valueOf(lTable) + "\\.", "T1A2B3L4E5.");
            lTableValue = lTableValue.replaceAll(laTable, joinSql);
            lTableValue = lTableValue.replaceAll("T1A2B3L4E5.", String.valueOf(lTable) + "\\.");
            tables.put(lTable, lTableValue);
        }
        StringBuilder strb = new StringBuilder();
        for (String tab : tables.values()) {
            strb.append(tab).append(",");
        }
        if (strb.length() > 0) {
            strb.setLength(strb.length() - 1);
        }
        return strb.toString();
    }
}

