/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.mysql5_0_8.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.mysql5_0_8.jdbc.ResultSet;
import org.zhiqim.mysql5_0_8.jdbc.RowData;

public class RowDataStatic
implements RowData {
    private int index = -1;
    private List rows;
    ResultSet owner;

    public RowDataStatic(ArrayList rows) {
        this.rows = rows;
    }

    @Override
    public void addRow(byte[][] row) {
        this.rows.add(row);
    }

    @Override
    public void afterLast() {
        this.index = this.rows.size();
    }

    @Override
    public void beforeFirst() {
        this.index = -1;
    }

    @Override
    public void beforeLast() {
        this.index = this.rows.size() - 2;
    }

    @Override
    public void close() {
    }

    @Override
    public Object[] getAt(int atIndex) {
        if (atIndex < 0 || atIndex >= this.rows.size()) {
            return null;
        }
        return (Object[])this.rows.get(atIndex);
    }

    @Override
    public int getCurrentRowNumber() {
        return this.index;
    }

    @Override
    public ResultSet getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasNext() {
        boolean hasMore = this.index + 1 < this.rows.size();
        return hasMore;
    }

    @Override
    public boolean isAfterLast() {
        return this.index >= this.rows.size();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.index == -1 && this.rows.size() != 0;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.rows.size() == 0;
    }

    @Override
    public boolean isFirst() {
        return this.index == 0;
    }

    @Override
    public boolean isLast() {
        if (this.rows.size() == 0) {
            return false;
        }
        return this.index == this.rows.size() - 1;
    }

    @Override
    public void moveRowRelative(int rowsToMove) {
        this.index += rowsToMove;
    }

    @Override
    public Object[] next() {
        ++this.index;
        if (this.index < this.rows.size()) {
            return (Object[])this.rows.get(this.index);
        }
        return null;
    }

    @Override
    public void removeRow(int atIndex) {
        this.rows.remove(atIndex);
    }

    @Override
    public void setCurrentRow(int newIndex) {
        this.index = newIndex;
    }

    @Override
    public void setOwner(ResultSet rs) {
        this.owner = rs;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public boolean wasEmpty() {
        return this.rows != null && this.rows.size() == 0;
    }
}

