/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.mysql5_0_8.jdbc;

import java.sql.SQLException;
import org.zhiqim.mysql5_0_8.jdbc.CommunicationsException;
import org.zhiqim.mysql5_0_8.jdbc.Connection;
import org.zhiqim.mysql5_0_8.jdbc.Constants;
import org.zhiqim.mysql5_0_8.jdbc.Field;
import org.zhiqim.mysql5_0_8.jdbc.Messages;
import org.zhiqim.mysql5_0_8.jdbc.MysqlIO;
import org.zhiqim.mysql5_0_8.jdbc.ResultSet;
import org.zhiqim.mysql5_0_8.jdbc.RowData;
import org.zhiqim.mysql5_0_8.jdbc.Util;
import org.zhiqim.mysql5_0_8.jdbc.profiler.ProfileEventSink;
import org.zhiqim.mysql5_0_8.jdbc.profiler.ProfilerEvent;

public class RowDataDynamic
implements RowData {
    private int columnCount;
    private Field[] fields;
    private int index = -1;
    private MysqlIO io;
    private boolean isAfterEnd = false;
    private boolean isAtEnd = false;
    private boolean isBinaryEncoded = false;
    private Object[] nextRow;
    private ResultSet owner;
    private boolean streamerClosed = false;
    private boolean wasEmpty = false;

    public RowDataDynamic(MysqlIO io, int colCount, Field[] fields, boolean isBinaryEncoded) throws SQLException {
        this.io = io;
        this.columnCount = colCount;
        this.isBinaryEncoded = isBinaryEncoded;
        this.fields = fields;
        this.nextRecord();
    }

    @Override
    public void addRow(byte[][] row) throws SQLException {
        this.notSupported();
    }

    @Override
    public void afterLast() throws SQLException {
        this.notSupported();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.notSupported();
    }

    @Override
    public void beforeLast() throws SQLException {
        this.notSupported();
    }

    @Override
    public void close() throws SQLException {
        Connection conn;
        boolean hadMore = false;
        int howMuchMore = 0;
        while (this.hasNext()) {
            this.next();
            hadMore = true;
            if (++howMuchMore % 100 != 0) continue;
            Thread.yield();
        }
        if (this.owner != null && (conn = this.owner.connection) != null && conn.getUseUsageAdvisor() && hadMore) {
            ProfileEventSink eventSink = ProfileEventSink.getInstance(conn);
            eventSink.consumeEvent(new ProfilerEvent(0, "", this.owner.owningStatement == null ? "N/A" : this.owner.owningStatement.currentCatalog, this.owner.connectionId, this.owner.owningStatement == null ? -1 : this.owner.owningStatement.getId(), -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, null, String.valueOf(Messages.getString("RowDataDynamic.2")) + howMuchMore + Messages.getString("RowDataDynamic.3") + Messages.getString("RowDataDynamic.4") + Messages.getString("RowDataDynamic.5") + Messages.getString("RowDataDynamic.6") + this.owner.pointOfOrigin));
        }
        this.fields = null;
        this.owner = null;
    }

    @Override
    public Object[] getAt(int ind) throws SQLException {
        this.notSupported();
        return null;
    }

    @Override
    public int getCurrentRowNumber() throws SQLException {
        this.notSupported();
        return -1;
    }

    @Override
    public ResultSet getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasNext() throws SQLException {
        boolean hasNext;
        boolean bl = hasNext = this.nextRow != null;
        if (!hasNext && !this.streamerClosed) {
            this.io.closeStreamer(this);
            this.streamerClosed = true;
        }
        return hasNext;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.isAfterEnd;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.index < 0;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.notSupported();
        return false;
    }

    @Override
    public void moveRowRelative(int rows) throws SQLException {
        this.notSupported();
    }

    @Override
    public Object[] next() throws SQLException {
        if (this.index != Integer.MAX_VALUE) {
            ++this.index;
        }
        Object[] ret = this.nextRow;
        this.nextRecord();
        return ret;
    }

    private void nextRecord() throws SQLException {
        try {
            if (!this.isAtEnd) {
                this.nextRow = this.io.nextRow(this.fields, this.columnCount, this.isBinaryEncoded, 1007);
                if (this.nextRow == null) {
                    this.isAtEnd = true;
                    if (this.index == -1) {
                        this.wasEmpty = true;
                    }
                }
            } else {
                this.isAfterEnd = true;
            }
        }
        catch (CommunicationsException comEx) {
            comEx.setWasStreamingResults();
            throw comEx;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            String exceptionType = ex.getClass().getName();
            String exceptionMessage = ex.getMessage();
            exceptionMessage = String.valueOf(exceptionMessage) + Messages.getString("RowDataDynamic.7");
            exceptionMessage = String.valueOf(exceptionMessage) + Util.stackTraceToString(ex);
            throw new SQLException(String.valueOf(Messages.getString("RowDataDynamic.8")) + exceptionType + Messages.getString("RowDataDynamic.9") + exceptionMessage, "S1000");
        }
    }

    private void notSupported() throws SQLException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void removeRow(int ind) throws SQLException {
        this.notSupported();
    }

    @Override
    public void setCurrentRow(int rowNumber) throws SQLException {
        this.notSupported();
    }

    @Override
    public void setOwner(ResultSet rs) {
        this.owner = rs;
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    class OperationNotSupportedException
    extends SQLException {
        private static final long serialVersionUID = 1L;

        OperationNotSupportedException() {
            super(Messages.getString("RowDataDynamic.10"), "S1009");
        }
    }
}

