/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.httpd.HttpSslConfig;
import org.zhiqim.httpd.nio.HttpNioConnection;
import org.zhiqim.httpd.nio.HttpNioListener;
import org.zhiqim.httpd.nio.HttpNioSslConnection;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Threads;

public class HttpNioSslListener
extends HttpNioListener {
    private final HttpSslConfig ssl = new HttpSslConfig();
    private SSLContext sslContext;

    public HttpNioSslListener(HttpServer server) {
        super(server);
    }

    @Override
    public String getScheme() {
        return "https";
    }

    @Override
    protected void openBeforeInner() {
        try {
            this.ssl.initParam(this.listenerGroup);
            this.sslContext = this.ssl.createSSLContext();
        }
        catch (Exception e) {
            throw Asserts.exception((Exception)e);
        }
    }

    @Override
    protected void onAccept(SelectionKey key) {
        block4: {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            HttpNioConnection conn = null;
            SocketChannel socket = null;
            try {
                socket = server.accept();
                socket.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                socket.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)this.soLingerS);
                socket.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                socket.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.soRecvBuf);
                socket.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.soSendBuf);
                conn = this.newConnection(socket);
                if (!this.ssl.doHandshake((HttpNioSslConnection)conn)) {
                    conn.close();
                    return;
                }
                socket.configureBlocking(false);
                socket.register(this.selector, 1, this.add(conn));
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    conn.close();
                }
                if (socket == null) break block4;
                Threads.closeIgnoreException((AutoCloseable)socket);
            }
        }
    }

    @Override
    protected HttpNioSslConnection newConnection(SocketChannel socket) throws IOException {
        InetAddress remoteAddress = ((InetSocketAddress)socket.getRemoteAddress()).getAddress();
        SSLEngine engine = this.sslContext.createSSLEngine();
        engine.setUseClientMode(this.ssl.isClientAuth());
        engine.setWantClientAuth(this.ssl.isClientAuth());
        engine.setEnableSessionCreation(true);
        return new HttpNioSslConnection(this, socket, remoteAddress, engine);
    }
}

