/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.nio;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.zhiqim.httpd.HttpInputStream;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;

public class HttpNioSslBuffer {
    private static final Log log = LogFactory.getLog(HttpNioSslBuffer.class);
    private SSLEngine sslEngine;
    private ByteBuffer appBuf;
    private ByteBuffer tmpBuf;

    public HttpNioSslBuffer(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.appBuf = ByteBuffer.allocate(sslEngine.getSession().getApplicationBufferSize() + 10);
        this.tmpBuf = ByteBuffer.allocate(sslEngine.getSession().getPacketBufferSize());
        this.tmpBuf.flip();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int parseBuffer(ByteBuffer netBuf, HttpInputStream input) {
        try {
            SSLEngineResult result;
            netBuf.flip();
            ByteBuffer curBuf = netBuf;
            if (this.tmpBuf.hasRemaining()) {
                curBuf = ByteBuffer.allocate(this.tmpBuf.remaining() + netBuf.remaining());
                curBuf.put(this.tmpBuf).put(netBuf).flip();
                this.tmpBuf.clear().flip();
            }
            while (true) {
                if (!curBuf.hasRemaining()) {
                    return 1;
                }
                this.appBuf.clear();
                result = this.sslEngine.unwrap(curBuf, this.appBuf);
                if (result.getStatus() != SSLEngineResult.Status.OK) break;
                input.addBuffer(this.appBuf);
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.tmpBuf.clear();
                this.tmpBuf.put(curBuf);
                this.tmpBuf.flip();
                return 0;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                return -1;
            }
            log.error((Object)"HTTPS\u89e3\u6790\u7f51\u7edc\u5305\u65f6\uff0c\u4e0d\u652f\u6301\u72b6\u6001[%s]", new Object[]{result.getStatus()});
            return -1;
        }
        catch (Exception e) {
            log.error((Object)"HTTPS\u89e3\u6790\u7f51\u7edc\u5305\u65f6\u5f02\u5e38", (Throwable)e, new Object[0]);
            return -1;
        }
    }
}

