/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.entities;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpEntity;
import org.zhiqim.httpd.HttpException;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Streams;

public class FaviconEnitiy
implements HttpEntity {
    private byte[] faviconBytes = null;
    private long faviconModified = 0L;

    public FaviconEnitiy(HttpContext context) {
        String faviconPath = String.valueOf(context.getResourcePath()) + "/favicon.ico";
        if (context.isClasspath()) {
            URL url = Resources.getResource(FaviconEnitiy.class, (String)faviconPath);
            if (url == null) {
                this.faviconBytes = new byte[0];
            } else {
                try {
                    this.faviconBytes = Streams.getBytesClassPath(FaviconEnitiy.class, (String)faviconPath);
                    this.faviconModified = System.currentTimeMillis();
                }
                catch (IOException iOException) {
                    this.faviconBytes = new byte[0];
                }
            }
        } else {
            File file = new File(faviconPath);
            if (file == null || !file.isFile() || !file.canRead()) {
                return;
            }
            try {
                this.faviconBytes = Streams.getBytesFilePath((File)file);
                this.faviconModified = file.lastModified();
            }
            catch (IOException iOException) {
                this.faviconBytes = null;
            }
        }
    }

    @Override
    public boolean isMatch(String pathInContext) {
        return "/favicon.ico".equals(pathInContext);
    }

    @Override
    public void handle(HttpHeader request, HttpSender response) throws HttpException, IOException {
        HttpContext context = request.getContext();
        String faviconPath = String.valueOf(context.getResourcePath()) + "/favicon.ico";
        if (context.isClasspath()) {
            if (this.faviconBytes.length == 0) {
                response.sendError(404);
                return;
            }
        } else {
            File file = new File(faviconPath);
            if (file == null || !file.isFile() || !file.canRead()) {
                response.sendError(404);
                return;
            }
            if (this.faviconModified != file.lastModified()) {
                this.faviconModified = file.lastModified();
                this.faviconBytes = Streams.getBytesFilePath((File)file);
            }
        }
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        String faviconModifiedHttp = DateTimes.getDateTimeHttp((long)this.faviconModified);
        if (ifModifiedSince != null && ifModifiedSince.indexOf(faviconModifiedHttp) != -1) {
            response.setHeader("Cache-Control", "max-age=3600, public");
            response.sendError(304);
            return;
        }
        response.setContentType("image/x-icon");
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Last-Modified", faviconModifiedHttp);
        response.setHeader("Cache-Control", "max-age=3600, public");
        response.write(this.faviconBytes);
        response.commit();
    }
}

