/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.service;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.kernel.util.Validates;

public final class VcodeService
implements HttpExecutor,
ZmlContextConstants {
    private static Random random = new Random();

    @Override
    public boolean isMatch(String pathInContext) {
        return "/service/vcode.jpg".equals(pathInContext);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        float hSplit;
        if (!Validates.isWindows()) {
            System.setProperty("java.awt.headless", "true");
        }
        int width = request.getParameterInt("width", request.getContextAttributeInt("vcode.width", 60));
        int height = request.getParameterInt("height", request.getContextAttributeInt("vcode.height", 28));
        String textColor = request.getParameter("textColor", request.getContextAttributeString("vcode.textColor", "#ffffff"));
        String bgColor = request.getParameter("bgColor", request.getContextAttributeString("vcode.bgColor", "#0826A9"));
        int fontSize = request.getParameterInt("fontSize", request.getContextAttributeInt("vcode.fontSize", 18));
        String fontFamily = request.getParameter("fontFamily", request.getContextAttributeString("vcode.fontFamily", "Arial"));
        String fontWidthRatio = request.getParameter("fontWidthRatio", request.getContextAttributeString("vcode.fontWidthRatio", "0.6"));
        boolean isYawp = request.getParameterBoolean("yawp", request.getContextAttributeBoolean("vcode.yawp", false));
        boolean isDisturb = request.getParameterBoolean("disturb", request.getContextAttributeBoolean("vcode.disturb", false));
        float wSplit = (float)(width / 4) - (float)fontSize * Float.parseFloat(fontWidthRatio);
        if (wSplit < 0.0f) {
            wSplit = 0.0f;
        }
        if ((hSplit = (float)((height - fontSize) / 2)) < 0.0f) {
            hSplit = 0.0f;
        }
        int textRed = Integer.parseInt(textColor.substring(1, 3), 16);
        int textGreen = Integer.parseInt(textColor.substring(3, 5), 16);
        int textBlue = Integer.parseInt(textColor.substring(5), 16);
        Color text = new Color(textRed, textGreen, textBlue);
        int bgRed = Integer.parseInt(bgColor.substring(1, 3), 16);
        int bgGreen = Integer.parseInt(bgColor.substring(3, 5), 16);
        int bgBlue = Integer.parseInt(bgColor.substring(5), 16);
        Color bg = new Color(bgRed, bgGreen, bgBlue);
        Font font = new Font(fontFamily, 0, fontSize);
        response.setContentType("image/jpeg");
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        g.setColor(bg);
        g.fillRect(0, 0, width, height);
        g.setFont(font);
        if (isYawp) {
            this.doAddYawp(image, width, height);
        }
        if (isDisturb) {
            this.doAddDisturb(g, width, height);
        }
        Random random = new Random();
        String sRand = "";
        int i = 0;
        while (i < 4) {
            String rand = String.valueOf(random.nextInt(10));
            sRand = String.valueOf(sRand) + rand;
            g.setColor(text);
            int x = Math.round((float)(width / 4 * i) + wSplit / 2.0f);
            int y = Math.round((float)fontSize + hSplit) - 2;
            g.drawString(rand, x, y);
            ++i;
        }
        g.dispose();
        request.getSession().setAttribute("_vcode_", sRand);
        ImageIO.write((RenderedImage)image, "JPEG", response.getOutputStream());
    }

    private void doAddYawp(BufferedImage image, int width, int height) {
        float yawpRate = 0.08f;
        int area = (int)(yawpRate * (float)width * (float)height);
        int i = 0;
        while (i < area) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int rgb = this.getRandomColorInt();
            image.setRGB(x, y, rgb);
            ++i;
        }
    }

    private void doAddDisturb(Graphics g, int width, int height) {
        g.setColor(this.getRandomColor(160, 200));
        Random rd = new Random();
        int i = 0;
        while (i < 20) {
            int x = rd.nextInt(width - 1);
            int y = rd.nextInt(height - 1);
            int xl = rd.nextInt(6) + 1;
            int yl = rd.nextInt(12) + 1;
            g.drawLine(x, y, x + xl + 40, y + yl + 20);
            ++i;
        }
    }

    private Color getRandomColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private int getRandomColorInt() {
        int[] rgb = new int[3];
        int i = 0;
        while (i < 3) {
            rgb[i] = random.nextInt(255);
            ++i;
        }
        int color = 0;
        int[] nArray = rgb;
        int n = rgb.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            color <<= 8;
            color |= c;
            ++n2;
        }
        return color;
    }
}

