/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.returns;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.context.core.Return;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Htmls;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Zml;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.Zmls;

public class ReturnView
implements Return {
    @Override
    public void process(HttpRequest request) {
        this.process(request, request.getView(), request.getInclude());
    }

    public void process(HttpRequest request, String viewPath, String includePath) {
        HttpResponse response = request.getResponse();
        HttpSession session = request.getSession();
        Context context = (Context)request.getContext();
        ZmlConfig config = context.getConfig();
        ZmlEngine engine = context.getZmlEngine();
        HashMapSO variableMap = new HashMapSO();
        HashMap<String, String> paramMap = request.getParameterMap();
        if (!paramMap.isEmpty()) {
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                String key = entry.getKey();
                String value = Htmls.filterAll((String)entry.getValue());
                variableMap.put(key, (Object)value);
            }
        }
        variableMap.putAll(request.getAttributeMap());
        if (session != null) {
            variableMap.put("sessionId", (Object)request.getSessionId());
            variableMap.put("sessionUser", (Object)request.getSessionUser());
            variableMap.put("sessionName", (Object)request.getSessionName());
        }
        variableMap.put("request", (Object)request);
        variableMap.put("response", (Object)response);
        variableMap.put("session", (Object)session);
        variableMap.put("context", (Object)context);
        variableMap.put("log", (Object)log);
        try {
            if (!Validates.isEmptyBlank((String)includePath)) {
                if (includePath.contains("${") || includePath.contains("<#")) {
                    includePath = Zmls.parse((String)includePath, (MapSO)variableMap, (MapS[])new MapS[]{config});
                }
                if (!Validates.isEmptyBlank((String)includePath)) {
                    variableMap.put("include", (Object)includePath);
                    variableMap.put("includeList", (Object)Lists.toStringList((String)includePath));
                }
            }
            if (viewPath.contains("${") || viewPath.contains("<#")) {
                viewPath = Zmls.parse((String)viewPath, (MapSO)variableMap, (MapS[])new MapS[]{config});
            }
            Zml zml = engine.getZml(viewPath);
            zml.process(response.getOutputStream(), response.getCharacterEncoding(), (MapSO)variableMap, new MapS[]{config});
        }
        catch (Exception e) {
            log.error((Throwable)e);
            try {
                response.print(e.getMessage());
                response.commit();
            }
            catch (IOException iOException) {}
        }
    }
}

