/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.config;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.annotation.AnAction;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.context.annotation.AnInterceptNot;
import org.zhiqim.httpd.context.config.ZAction;
import org.zhiqim.httpd.context.config.ZActionPackage;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.context.extend.SwitchAction;
import org.zhiqim.kernel.control.FilterHandler;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Jars;
import org.zhiqim.kernel.util.Lists;

public class ZActionPackageLoader
implements FilterHandler {
    private static final Log log = LogFactory.getLog(ZActionPackageLoader.class);
    private ZActionPackage actionPackage;

    public ZActionPackageLoader(ZActionPackage wapper) {
        this.actionPackage = wapper;
    }

    public boolean handle(Object obj) throws Exception {
        Object[] objs = (Object[])obj;
        String className = null;
        if (objs[0] instanceof File) {
            File classPath = (File)objs[0];
            File classFile = (File)objs[1];
            className = Files.getClassName((File)classPath, (File)classFile);
        } else {
            JarEntry jarEntry = (JarEntry)objs[1];
            className = Jars.getClassName((JarEntry)jarEntry);
        }
        if (className == null || !className.startsWith(this.actionPackage.getActionPackage())) {
            return true;
        }
        Class clazz = Classes.forName((String)className);
        if (!Classes.isImplement((Class)clazz, Action.class)) {
            log.error((Object)"\u7c7b[%s]\u672a\u5b9e\u73b0Action\u63a5\u53e3", new Object[]{className});
            return false;
        }
        Action actioner = (Action)Classes.newInstance((Class)clazz);
        if (actioner instanceof SwitchAction) {
            Method[] methods;
            AnIntercept classInterceptor = clazz.getAnnotation(AnIntercept.class);
            Method[] methodArray = methods = clazz.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                AnAction anAction = method.getAnnotation(AnAction.class);
                if (anAction != null) {
                    Class<?>[] params = method.getParameterTypes();
                    if (params.length != 1) {
                        log.error((Object)"\u7c7b[%s]\u65b9\u6cd5[%s]\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e", new Object[]{className, method.getName()});
                        return false;
                    }
                    if (params[0] != HttpRequest.class) {
                        log.error((Object)"\u7c7b[%s]\u65b9\u6cd5[%s]\u53c2\u6570\u4e0d\u662f[HttpRequest]", new Object[]{className, method.getName()});
                        return false;
                    }
                    AnIntercept methodInterceptor = clazz.getAnnotation(AnIntercept.class);
                    AnInterceptNot methodInterceptorNot = clazz.getAnnotation(AnInterceptNot.class);
                    String interceptor = ZActionPackageLoader.getInterceptor(classInterceptor, methodInterceptor, methodInterceptorNot);
                    this.actionPackage.getConfig().setActionOnPath(anAction.path(), actioner);
                    ZAction action = new ZAction();
                    action.setName(anAction.name());
                    action.setPath(anAction.path());
                    action.setInterceptor(interceptor);
                    action.setForward(anAction.forward());
                    action.setRedirect(anAction.redirect());
                    action.setView(anAction.view());
                    action.setClazz(className);
                    action.setMethod(method.getName());
                    action.setSuccess(anAction.success());
                    this.actionPackage.addActionOnPackage(action);
                }
                ++n2;
            }
        } else {
            AnAction anAction = clazz.getAnnotation(AnAction.class);
            if (anAction == null) {
                return true;
            }
            AnIntercept anInterceptor = clazz.getAnnotation(AnIntercept.class);
            String interceptor = anInterceptor == null ? "" : Arrays.toFilterSameStr((String[])anInterceptor.value());
            this.actionPackage.getConfig().setActionOnPath(anAction.path(), actioner);
            ZAction action = new ZAction();
            action.setName(anAction.name());
            action.setPath(anAction.path());
            action.setInterceptor(interceptor);
            action.setForward(anAction.forward());
            action.setRedirect(anAction.redirect());
            action.setView(anAction.view());
            action.setInclude(anAction.include());
            action.setClazz(className);
            action.setMethod(null);
            action.setSuccess(anAction.success());
            this.actionPackage.addActionOnPackage(action);
        }
        return true;
    }

    public static String getInterceptor(AnIntercept classInterceptor, AnIntercept methodInterceptor, AnInterceptNot methodInterceptorNot) {
        String interceptor;
        int n;
        int n2;
        String[] stringArray;
        String[] interceptors;
        ArrayList<String> interceptorList = new ArrayList<String>();
        if (classInterceptor != null) {
            stringArray = interceptors = classInterceptor.value();
            n2 = interceptors.length;
            n = 0;
            while (n < n2) {
                interceptor = stringArray[n];
                interceptorList.add(interceptor);
                ++n;
            }
        }
        if (methodInterceptor != null) {
            stringArray = interceptors = methodInterceptor.value();
            n2 = interceptors.length;
            n = 0;
            while (n < n2) {
                interceptor = stringArray[n];
                interceptorList.add(interceptor);
                ++n;
            }
        }
        if (methodInterceptorNot != null) {
            stringArray = interceptors = methodInterceptorNot.value();
            n2 = interceptors.length;
            n = 0;
            while (n < n2) {
                interceptor = stringArray[n];
                interceptorList.remove(interceptor);
                ++n;
            }
        }
        return Lists.toString(interceptorList, (String)",");
    }
}

