/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import org.zhiqim.httpd.HttpInputStream;
import org.zhiqim.httpd.HttpWebsocketMessage;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Strings;

public class HttpWebsocketMessageAsync
extends HttpWebsocketMessage
implements CodeConstants {
    private int step;
    private int first;
    private int second;
    private byte[] buffer;
    private int bufferOffset;
    private int masksOffset;
    private int contentOffset;

    public boolean parse(HttpInputStream in) throws IOException {
        byte[] buf;
        if (this.step < 1) {
            this.first = in.read();
            if (this.first == -1) {
                return false;
            }
            this.step = 1;
        }
        if (this.step < 2) {
            this.second = in.read();
            if (this.second == -1) {
                return false;
            }
            this.step = 2;
        }
        this.fin = (this.first & 0x80) != 0;
        this.opcode = this.first & 0xF;
        this.mask = (this.second & 0x80) != 0;
        this.contentLen = this.length = this.second & 0x7F;
        if (this.length == 126) {
            if (this.step < 3) {
                if (this.buffer == null) {
                    this.buffer = new byte[2];
                    this.bufferOffset = 0;
                }
                if ((buf = in.read(2 - this.bufferOffset)) != null && buf.length > 0) {
                    this.bufferOffset = Bytes.putBytes((byte[])this.buffer, (int)this.bufferOffset, (byte[])buf);
                }
                if (this.bufferOffset < 2) {
                    return false;
                }
                this.contentLen = Bytes.BU.getShortUnsigned(this.buffer, 0);
                this.step = 3;
            }
        } else if (this.length == 127 && this.step < 3) {
            if (this.buffer == null) {
                this.buffer = new byte[8];
                this.bufferOffset = 0;
            }
            if ((buf = in.read(8 - this.bufferOffset)) != null && buf.length > 0) {
                this.bufferOffset = Bytes.putBytes((byte[])this.buffer, (int)this.bufferOffset, (byte[])buf);
            }
            if (this.bufferOffset < 8) {
                return false;
            }
            long len = Bytes.BU.getLong(buf, 0);
            if (len > Integer.MAX_VALUE) {
                throw Asserts.exception((String)"\u8d85\u51fa\u652f\u6301\u7684\u80fd\u529b");
            }
            this.contentLen = (int)len;
            this.step = 3;
        }
        if (this.step < 4) {
            if (this.mask) {
                if (this.masks == null) {
                    this.masks = new byte[4];
                    this.masksOffset = 0;
                }
                if ((buf = in.read(4 - this.masksOffset)) != null && buf.length > 0) {
                    this.masksOffset = Bytes.putBytes((byte[])this.masks, (int)this.masksOffset, (byte[])buf);
                }
                if (this.masksOffset < 4) {
                    return false;
                }
            }
            this.step = 4;
        }
        if (this.step < 5) {
            if (this.contentLen > 0) {
                if (this.content == null) {
                    this.content = new byte[this.contentLen];
                    this.contentOffset = 0;
                }
                if ((buf = in.read(this.contentLen - this.contentOffset)) != null && buf.length > 0) {
                    this.contentOffset = Bytes.putBytes((byte[])this.content, (int)this.contentOffset, (byte[])buf);
                }
                if (this.contentOffset < this.contentLen) {
                    return false;
                }
                if (this.mask) {
                    int i = 0;
                    while (i < this.content.length) {
                        this.content[i] = (byte)(this.content[i] ^ this.masks[i % 4]);
                        ++i;
                    }
                }
                if (this.isText()) {
                    this.text = Strings.newStringUTF8((byte[])this.content);
                } else if (this.isClose()) {
                    this.text = String.valueOf(Bytes.BU.getShortUnsigned(this.content, 0));
                }
            }
            this.step = 5;
        }
        return true;
    }

    public boolean isParsed() {
        return this.step == 5;
    }
}

