/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpCookie;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpRequestAbs;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpSenderImpl;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.HttpSessionManager;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Validates;

public class HttpResponseImpl
implements HttpResponse {
    private HttpRequestAbs request;
    private HttpSenderImpl sender;
    private HttpContext context;
    private List<HttpCookie> cookies;
    private boolean addSessionIdToCookie;
    private boolean addCookieToSender;

    public HttpResponseImpl(HttpRequestAbs request) {
        this.request = request;
        this.sender = (HttpSenderImpl)request.getSender();
        this.context = request.getContext();
        this.cookies = new ArrayList<HttpCookie>();
    }

    @Override
    public String getId() {
        return this.request.getId();
    }

    @Override
    public HttpRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpContext getContext() {
        return this.context;
    }

    @Override
    public boolean isEditable() {
        return this.request != null && this.request.isEditable();
    }

    @Override
    public boolean isCommitted() {
        return this.request == null || this.request.isCommitted();
    }

    @Override
    public void setStatus(int code) {
        this.sender.setStatus(code);
    }

    @Override
    public void sendError(int code) throws IOException {
        this.sendError(code, null);
    }

    @Override
    public void sendError(int code, String message) throws IOException {
        this.sender.sendError(code, message);
    }

    @Override
    public void sendErrorHTML(int code) throws IOException {
        this.sender.sendErrorHTML(code);
    }

    @Override
    public void sendErrorHTML(int code, String reason) throws IOException {
        this.sender.sendErrorHTML(code, reason);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        Asserts.asState((String)(!this.isCommitted() ? null : "\u5df2\u63d0\u4ea4\u4e0d\u5141\u8bb8\u518d\u63d0\u4ea4"));
        this.addCookieSessionId();
        this.addCookieToSender();
        this.sender.sendRedirect(this.encodeURL(location));
    }

    @Override
    public void sendHeader(int code) throws IOException {
        this.addCookieSessionId();
        this.addCookieToSender();
        this.sender.sendHeader(code);
    }

    @Override
    public void sendContent(int code, String content) throws IOException {
        this.addCookieSessionId();
        this.addCookieToSender();
        this.sender.sendContent(code, content);
    }

    @Override
    public String encodeURL(String url) {
        if (this.context == null) {
            return url;
        }
        HttpSessionManager sessionManager = this.context.getSessionManager();
        if (sessionManager == null) {
            return url;
        }
        if (this.context.isCookieUse()) {
            return url;
        }
        HttpSession session = this.getRequest().getSession();
        if (session == null) {
            return url;
        }
        String sessionId = session.getId();
        if (sessionId == null) {
            return url;
        }
        int ind = url.indexOf("?");
        url = ind == -1 ? String.valueOf(url) + "?" + sessionManager.getSessionIdName() + "=" + sessionId : String.valueOf(url) + "&" + sessionManager.getSessionIdName() + "=" + sessionId;
        return url;
    }

    @Override
    public int getStatus() {
        return this.sender.getStatus();
    }

    @Override
    public String getReason() {
        return this.sender.getReason();
    }

    @Override
    public void setHeader(String key, Object value) {
        this.sender.setHeader(key, value);
    }

    @Override
    public void setDateHeader(String key, long value) {
        this.sender.setDateHeader(key, value);
    }

    @Override
    public void setCacheControl(String value) {
        this.setHeader("Cache-Control", value);
    }

    @Override
    public void setCacheControlPrivate() {
        this.setHeader("Pragma", "private");
        this.setHeader("Cache-Control", "private");
    }

    @Override
    public void addHeader(String key, Object value) {
        this.sender.addHeader(key, value);
    }

    @Override
    public void addDateHeader(String key, long value) {
        this.sender.addDateHeader(key, value);
    }

    @Override
    public void removeHeader(String key) {
        this.sender.removeHeader(key);
    }

    @Override
    public String getHeader(String key) {
        return this.sender.getHeader(key);
    }

    @Override
    public boolean hasHeader(String key) {
        return this.sender.hasHeader(key);
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this.sender.setCharacterEncoding(encoding);
    }

    @Override
    public String getCharacterEncoding() {
        String encoding = this.sender.getCharacterEncoding();
        if (Validates.isEmptyBlank((String)encoding)) {
            encoding = this.getRequest().getCharacterEncoding();
        }
        return Validates.isEmptyBlank((String)encoding) ? "UTF-8" : encoding;
    }

    @Override
    public void setContentType(String contentType) {
        this.sender.setContentType(contentType);
    }

    @Override
    public void setContentTypeNoCharset(String contentType) {
        this.sender.setContentTypeNoCharset(contentType);
    }

    public long getFlushLength() {
        return this.sender.getFlushLength();
    }

    @Override
    public void addCookie(String name, String value) {
        this.cookies.add(new HttpCookie(name, value));
    }

    @Override
    public void addCookie(String name, String value, int seconds) {
        HttpCookie cookie = new HttpCookie(name, value);
        cookie.setMaxAge(seconds);
        this.addCookie(cookie);
    }

    @Override
    public void addCookie(HttpCookie cookie) {
        this.cookies.add(cookie);
    }

    @Override
    public void removeCookie(String name) {
        Iterator<HttpCookie> it = this.cookies.iterator();
        while (it.hasNext()) {
            HttpCookie cookie = it.next();
            if (!name.equals(cookie.getName())) continue;
            it.remove();
        }
        this.addCookie(name, null, -1);
    }

    @Override
    public void clearCookie() {
        this.cookies.clear();
    }

    private void addCookieToSender() {
        int port;
        String path;
        if (this.addCookieToSender || this.cookies.isEmpty() || this.context == null || !this.context.isCookieUse()) {
            return;
        }
        String host = this.context.getCookieDomain();
        if (Validates.isEmpty((String)host)) {
            host = this.getRequest().getHostOnly();
        }
        if (Validates.isEmpty((String)(path = this.context.getCookiePath()))) {
            path = this.context.getContextPath();
        }
        if ((port = this.context.getCookiePort()) == 0) {
            port = this.getRequest().getPort();
        }
        for (HttpCookie cookie : this.cookies) {
            this.sender.addMultiHeader("Set-Cookie", cookie.getResponseValue(path, host, port));
        }
        this.addCookieToSender = true;
    }

    private void addCookieSessionId() {
        if (this.addSessionIdToCookie || this.context == null || !this.context.isCookieUse()) {
            return;
        }
        HttpSessionManager sessionManager = this.context.getSessionManager();
        if (sessionManager == null) {
            return;
        }
        HttpSession session = this.request.getSession();
        if (session == null) {
            return;
        }
        String sessionId = session.getId();
        this.addCookie(new HttpCookie(sessionManager.getSessionIdName(), sessionId));
        String oldSessionId = session.getOldSessionId();
        if (oldSessionId != null) {
            if (!sessionId.equals(oldSessionId)) {
                sessionManager.invalidateSession(oldSessionId);
            }
            session.clearOldSessionId();
            sessionManager.setSession(session);
        }
        this.addSessionIdToCookie = true;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.sender.getOutputStream();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.addCookieSessionId();
        this.addCookieToSender();
        this.sender.write(b);
    }

    @Override
    public void println(String str) throws IOException {
        this.addCookieSessionId();
        this.addCookieToSender();
        this.sender.println(str);
    }

    @Override
    public void println() throws IOException {
        this.addCookieSessionId();
        this.addCookieToSender();
        this.sender.println();
    }

    @Override
    public void print(String str) throws IOException {
        this.addCookieSessionId();
        this.addCookieToSender();
        this.sender.print(str);
    }

    @Override
    public void commit() throws IOException {
        if (this.isCommitted()) {
            return;
        }
        this.addCookieSessionId();
        this.addCookieToSender();
        this.sender.commit();
    }

    public String toString() {
        return this.sender.toString();
    }

    void destroy() {
        if (this.cookies != null) {
            this.cookies.clear();
            this.cookies = null;
        }
        this.request = null;
        this.sender = null;
        this.context = null;
    }

    byte[] buildChunkedHeader(boolean chunked) {
        return this.sender.buildChunkedHeader(chunked);
    }
}

