/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;

public class HttpCookie
implements HttpdConstants {
    private String name;
    private String value;
    private int maxAge;
    private boolean secure;

    public HttpCookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public HttpCookie(String name, String value, int maxAge) {
        this.name = name;
        this.value = value;
        this.maxAge = maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getResponse(String contextPath, String domain, int port) {
        return "Set-Cookie" + ':' + this.getResponseValue(contextPath, domain, port);
    }

    public String getResponseValue(String contextPath, String domain, int port) {
        StringBuilder strb = new StringBuilder();
        strb.append(this.name).append("=").append(Urls.encodeUTF8((String)this.value));
        strb.append(";").append("Version").append("=").append(1);
        if (this.maxAge == 0) {
            strb.append(";").append("Discard").append("=").append("\"true\"");
        } else {
            strb.append(";").append("Max-Age").append("=").append(this.maxAge);
        }
        if (domain != null) {
            strb.append(";").append("Domain").append("=").append(domain);
        }
        if (port != -1) {
            strb.append(";").append("Port").append("=").append(port);
        }
        strb.append(";").append("Path").append("=").append(Strings.addEndsWith((String)contextPath, (String)"/"));
        if (this.secure) {
            strb.append(";").append("Secure");
        }
        strb.append(";").append("HttpOnly");
        return strb.toString();
    }
}

