/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.util.UUID;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.enumerated.LetterCase;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.seqs.Sequence;

@AnAlias(value={"Ids"})
public class Ids {
    private static final Sequence sequence3 = new Sequence(3);
    private static final Sequence sequence4 = new Sequence(4);
    private static final Sequence sequence5 = new Sequence(5);

    public static final String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static final String uuid(LetterCase letter) {
        return letter.toCase(Ids.uuid(), LetterCase.LOWER);
    }

    public static final long longId() {
        return Ids.longId(sequence4);
    }

    public static final long longId(Sequence sequence4) {
        long time = Longs.toLong(DateTimes.getDateTime12String());
        int seq = sequence4.nextInt();
        return time * 10000L + (long)seq;
    }

    public static final long longId13() {
        return Ids.longId13(sequence3);
    }

    public static final long longId13(Sequence sequence3) {
        int year = DateTimes.getCurrentYear();
        long yearTime = DateTimes.toLong(year, 1, 1, 0, 0, 0) / 1000L;
        long currtime = System.currentTimeMillis() / 1000L;
        int seq = sequence3.nextInt();
        return (long)(year % 100) * 100000000000L + (currtime - yearTime) * 1000L + (long)seq;
    }

    public static final long longId13_4() {
        return Ids.longId13_4(sequence4);
    }

    public static final long longId13_4(Sequence sequence4) {
        int year = DateTimes.getCurrentYear();
        long yearTime = DateTimes.toLong(year, 1, 1, 0, 0, 0) / 1000L;
        long currtime = System.currentTimeMillis() / 1000L;
        int seq = sequence4.nextInt();
        return (long)(year % 100) * 100000000000L + (long)((double)(currtime - yearTime) / 3.16224) * 10000L + (long)seq;
    }

    public static final long longId19() {
        return Ids.longId19(sequence5);
    }

    public static final long longId19(Sequence sequence5) {
        long time = Longs.toLong(DateTimes.getDateTime14String());
        int seq = sequence5.nextInt();
        return time * 100000L + (long)seq;
    }
}

