/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNullable;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.control.Filter;
import org.zhiqim.kernel.control.FilterEndsWith;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Replaces;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.Windows;
import org.zhiqim.kernel.util.Zips;

@AnAlias(value={"Files"})
public class Files
implements CodeConstants {
    public static boolean exists(File path) {
        if (path == null) {
            return false;
        }
        try {
            return path.exists();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean exists(String path) {
        if (Validates.isEmpty(path)) {
            return false;
        }
        return Files.exists(new File(path));
    }

    public static boolean exists(File dir, String name) {
        if (dir == null || Validates.isEmptyBlank(name)) {
            return false;
        }
        if (!Files.exists(dir)) {
            return false;
        }
        return Files.exists(new File(dir, name));
    }

    @Deprecated
    public static boolean isExists(File path) {
        return Files.exists(path);
    }

    @Deprecated
    public static boolean isExists(String path) {
        return Files.exists(path);
    }

    public static boolean isFile(String path) {
        if (Validates.isEmpty(path)) {
            return false;
        }
        File file = new File(path);
        return Files.isFile(file);
    }

    public static boolean isFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        return file.isFile();
    }

    public static boolean isDirectory(String path) {
        if (Validates.isEmpty(path)) {
            return false;
        }
        File dirFile = new File(path);
        return Files.isDirectory(dirFile);
    }

    public static boolean isDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return false;
        }
        return dir.isDirectory();
    }

    public static String toLinuxPath(String path) {
        return Replaces.replaceAllEscape(path, "\\", "/");
    }

    @AnNullable
    public static String getCanonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getFileExt(String path) {
        if (Validates.isEmptyBlank(path)) {
            return "";
        }
        int pos = (path = path.trim()).lastIndexOf(".");
        if (pos == -1) {
            return "";
        }
        String fileExt = path.substring(pos + 1);
        return fileExt.toLowerCase();
    }

    public static String fixFileExt(String fileExt) {
        return Validates.isEmptyBlank(fileExt) ? "" : "." + fileExt.trim();
    }

    public static String getFileDirPath(String filePath) {
        String v = Files.getFileDirPath(filePath, Systems.getFileSeparator());
        if (!Validates.isEmpty(v)) {
            return v;
        }
        return Files.getFileDirPath(filePath, "/");
    }

    public static String getFileDirPath(String filePath, String sep) {
        int pos = filePath.lastIndexOf(sep);
        if (pos == -1) {
            return "";
        }
        return filePath.substring(0, pos);
    }

    public static String getFileDir(String filePath) {
        String v = Files.getFileDir(filePath, Systems.getFileSeparator());
        if (!Validates.isEmpty(v)) {
            return v;
        }
        return Files.getFileDir(filePath, "/");
    }

    public static String getFileDir(String filePath, String sep) {
        int pos = filePath.lastIndexOf(sep);
        if (pos == -1) {
            return "";
        }
        return filePath.substring(0, pos + sep.length());
    }

    public static String getFileName(String filePath) {
        return Files.getFileName(filePath, Systems.getFileSeparator());
    }

    public static String getFileName(String filePath, String sep) {
        int pos = filePath.lastIndexOf(sep);
        if (pos == -1) {
            return Files.getFileNameLinux(filePath);
        }
        return filePath.substring(pos + 1);
    }

    public static String getFileNameLinux(String filePath) {
        int pos = filePath.lastIndexOf("/");
        if (pos == -1) {
            return filePath;
        }
        return filePath.substring(pos + 1);
    }

    public static String[] getDirectoryList(String fileDir) {
        if (Validates.isEmptyBlank(fileDir)) {
            return null;
        }
        File dir = new File(fileDir.trim());
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        String[] fileNames = dir.list();
        return fileNames;
    }

    public static boolean mkDirectory(File fileDir) {
        if (fileDir.exists()) {
            return true;
        }
        if (!fileDir.getParentFile().exists()) {
            Files.mkDirectory(fileDir.getParentFile());
        }
        return fileDir.mkdir();
    }

    public static boolean mkDirectory(String fileDir) {
        return Files.mkDirectory(new File(fileDir));
    }

    public static boolean copyDirectory(File src, String dest) throws Exception {
        if (src == null || !src.isDirectory()) {
            return false;
        }
        File destRoot = new File(dest);
        if (!destRoot.exists()) {
            destRoot.mkdir();
        }
        File[] entries = src.listFiles();
        int len = entries.length;
        int i = 0;
        while (i < len) {
            File entry = entries[i];
            String target = String.valueOf(dest) + Systems.getFileSeparator() + entry.getName();
            if (entry.isDirectory()) {
                Files.copyDirectory(entry, target);
            } else {
                File toFile = new File(target);
                Files.copyFile(entry, toFile);
            }
            ++i;
        }
        return true;
    }

    public static boolean deleteDirectory(String dir) throws Exception {
        if (Validates.isEmptyBlank(dir)) {
            return false;
        }
        return Files.deleteDirectory(new File(dir.trim()));
    }

    public static boolean deleteDirectory(File dir) throws Exception {
        File[] entries;
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        File[] fileArray = entries = dir.listFiles();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (entry.isFile()) {
                entry.delete();
            } else {
                Files.deleteDirectory(entry);
            }
            ++n2;
        }
        dir.delete();
        return true;
    }

    public static boolean deleteDirectory(String dir, List<String> forbidDirList) throws Exception {
        if (Validates.isEmptyBlank(dir)) {
            return false;
        }
        if (forbidDirList == null) {
            return Files.deleteDirectory(new File(dir.trim()));
        }
        return Files.deleteDirectory(new File(dir.trim()), forbidDirList);
    }

    public static boolean deleteDirectory(File dir, List<String> forbidDirList) throws Exception {
        File[] entries;
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        if (forbidDirList == null) {
            return Files.deleteDirectory(dir);
        }
        boolean isAllowDeleteCurrentDir = true;
        File[] fileArray = entries = dir.listFiles();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                file.delete();
            } else {
                boolean isAllowDelete = true;
                for (String forbid : forbidDirList) {
                    if (!Validates.isMatch(file.getName(), forbid)) continue;
                    isAllowDelete = false;
                    isAllowDeleteCurrentDir = false;
                    break;
                }
                if (isAllowDelete) {
                    Files.deleteDirectory(file, forbidDirList);
                }
            }
            ++n2;
        }
        if (isAllowDeleteCurrentDir) {
            dir.delete();
        }
        return true;
    }

    public static boolean newFile(String filePath) {
        return Files.newFile(new File(filePath));
    }

    public static boolean newFile(File file) {
        block3: {
            try {
                if (!file.exists()) break block3;
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        String fileDir = file.getParent();
        Files.mkDirectory(fileDir);
        file.createNewFile();
        return true;
    }

    public static boolean renameFile(File file, File dest) {
        return file.renameTo(dest);
    }

    public static boolean renameFile(String filePath, String destPath) {
        return Files.renameFile(new File(filePath), new File(destPath));
    }

    public static boolean renameFileName(String filePath, String newFileName) {
        String fileDir = Files.getFileDir(filePath);
        String destPath = String.valueOf(fileDir) + newFileName;
        return Files.renameFile(filePath, destPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File fromFile, File toFile) throws Exception {
        if (!Files.isFile(fromFile)) return false;
        if (toFile == null) {
            return false;
        }
        FileInputStream fis = new FileInputStream(fromFile);
        FileOutputStream fos = new FileOutputStream(toFile);
        FileChannel iChannel = fis.getChannel();
        FileChannel oChannel = fos.getChannel();
        FileLock iLock = null;
        FileLock oLock = null;
        try {
            iLock = iChannel.tryLock(0L, Long.MAX_VALUE, true);
            if (iLock == null) return false;
            if (!iLock.isValid()) {
                return false;
            }
            oLock = oChannel.tryLock();
            if (oLock == null) return false;
            if (!oLock.isValid()) {
                return false;
            }
            iChannel.transferTo(0L, iChannel.size(), oChannel);
            return true;
        }
        finally {
            if (iLock != null) {
                iLock.release();
            }
            if (oLock != null) {
                oLock.release();
            }
            iChannel.close();
            oChannel.close();
            fis.close();
            fos.close();
        }
    }

    public static boolean copyFile(String fromFile, String toFile) throws Exception {
        if (Validates.isEmptyBlank(fromFile) || Validates.isEmptyBlank(toFile)) {
            return false;
        }
        File from = new File(fromFile.trim());
        File to = new File(toFile.trim());
        return Files.copyFile(from, to);
    }

    public static boolean copyFile(String fromFile, String toDir, String fileName) throws Exception {
        if (Validates.isEmptyBlank(fromFile) || Validates.isEmptyBlank(toDir) || Validates.isEmptyBlank(fileName)) {
            return false;
        }
        File from = new File(fromFile.trim());
        if (!from.exists() || !from.isFile()) {
            return false;
        }
        if (!Validates.isEmpty(toDir = toDir.trim())) {
            File dir = new File(toDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            dir = null;
        }
        if (toDir.lastIndexOf(Systems.getFileSeparator()) != toDir.length()) {
            toDir = String.valueOf(toDir) + Systems.getFileSeparator();
        }
        File to = new File(String.valueOf(toDir) + fileName.trim());
        return Files.copyFile(from, to);
    }

    public static boolean deleteFile(String filePath) {
        if (Validates.isEmptyBlank(filePath)) {
            return false;
        }
        File file = new File(Strings.trim(filePath));
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    public static void deleteFile(File file, int depth) throws IOException {
        if (!file.delete() && file.isFile()) {
            throw new IOException("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a" + file);
        }
        File dir = file.getParentFile();
        int i = 0;
        while (i < depth) {
            if (!dir.delete()) break;
            dir = dir.getParentFile();
            ++i;
        }
    }

    public static String readUTF8(String filePath) {
        byte[] bytes = Files.read(filePath);
        return bytes == null ? null : (bytes.length == 0 ? "" : Strings.newStringUTF8(bytes));
    }

    public static String readUTF8(File file) {
        byte[] bytes = Files.read(file);
        return bytes == null ? null : (bytes.length == 0 ? "" : Strings.newStringUTF8(bytes));
    }

    public static String read(String filePath, String encoding) {
        byte[] bytes = Files.read(filePath);
        return bytes == null ? null : (bytes.length == 0 ? "" : Strings.newString(bytes, encoding));
    }

    public static String read(File file, String encoding) {
        byte[] bytes = Files.read(file);
        return bytes == null ? null : (bytes.length == 0 ? "" : Strings.newString(bytes, encoding));
    }

    @AnNullable
    public static byte[] read(String filePath) {
        return Files.read(new File(filePath));
    }

    @AnNullable
    public static byte[] read(File file) {
        return Files.read(file, 0x6400000);
    }

    @AnNullable
    public static byte[] read(File file, int max) {
        if (file == null || !file.isFile() || !file.canRead()) {
            return null;
        }
        Asserts.as(file.length() <= (long)max ? null : "\u6587\u4ef6\u957f\u5ea6\u5927\u4e8e\u6307\u5b9a\u7684\u5927\u5c0f[%d]", max);
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream input = new FileInputStream(file);){
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                Streams.putBytes(input, output);
                return output.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void read(FileChannel fileChannel, long pos, byte[] buffer, int off, int len) throws IOException {
        while (len > 0) {
            ByteBuffer buf = ByteBuffer.wrap(buffer, off, len);
            int count = fileChannel.read(buf, pos);
            if (count <= 0) {
                throw new EOFException("\u6309\u957f\u5ea6\u8bfb\u6587\u4ef6\u7ba1\u9053\u65f6,\u957f\u5ea6\u4e0d\u591f\u5373\u5230\u8fbe\u6d41\u5c3e\u7aef");
            }
            pos += (long)count;
            off += count;
            len -= count;
        }
    }

    public static int readMaybe(FileChannel fileChannel, long pos, byte[] buffer, int off, int len) throws IOException {
        int oLen = len;
        while (len > 0) {
            ByteBuffer buf = ByteBuffer.wrap(buffer, off, len);
            int count = fileChannel.read(buf, pos);
            if (count <= 0) {
                return oLen - len;
            }
            pos += (long)count;
            off += count;
            len -= count;
        }
        return oLen;
    }

    @AnNullable
    public static String readGZip(String filePath, String encoding) {
        byte[] bytes = Files.read(filePath);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return Zips.unGZipString(bytes, encoding);
    }

    public static long writeReturnSize(String filePath, InputStream input) {
        Asserts.notEmptyBlank(filePath, "filePath");
        Asserts.notNull(input, "input");
        String fileDirPath = Files.getFileDirPath(filePath);
        Asserts.as(Files.mkDirectory(fileDirPath) ? null : "\u5199\u5165\u6587\u4ef6\u65f6[" + filePath + "]\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        File file = new File(filePath);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream output = new FileOutputStream(file);){
                Streams.putBytes(input, output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw Asserts.exception("\u5199\u5165\u6587\u4ef6\u65f6[" + filePath + "]\uff0c\u5f02\u5e38", e);
        }
        return file.length();
    }

    public static long writeReturnSize(String filePath, byte[] bytes) {
        Asserts.notEmptyBlank(filePath, "filePath");
        Asserts.notNull(bytes, "bytes");
        String fileDirPath = Files.getFileDirPath(filePath);
        Asserts.as(Files.mkDirectory(fileDirPath) ? null : "\u5199\u5165\u6587\u4ef6\u65f6[" + filePath + "]\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        File file = new File(filePath);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(bytes);
                fos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw Asserts.exception("\u5199\u5165\u6587\u4ef6\u65f6[" + filePath + "]\uff0c\u5f02\u5e38", e);
        }
        return file.length();
    }

    public static boolean write(String filePath, byte[] bytes) {
        block13: {
            Asserts.notEmptyBlank(filePath, "filePath");
            Asserts.notNull(bytes, "bytes");
            String fileDirPath = Files.getFileDirPath(filePath);
            Asserts.as(Files.mkDirectory(fileDirPath) ? null : "\u5199\u5165\u6587\u4ef6\u65f6[" + filePath + "]\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
            Throwable throwable = null;
            Object var4_5 = null;
            FileOutputStream fos = new FileOutputStream(filePath);
            try {
                fos.write(bytes);
                fos.flush();
                if (fos == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }
            fos.close();
        }
        return true;
    }

    public static boolean write(File file, byte[] bytes, boolean append) {
        block13: {
            Asserts.notNull(file, "file");
            Asserts.notNull(bytes, "bytes");
            Asserts.as(Files.mkDirectory(file.getParentFile()) ? null : "\u5199\u5165\u6587\u4ef6\u65f6[" + file + "]\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
            Throwable throwable = null;
            Object var4_5 = null;
            FileOutputStream fos = new FileOutputStream(file, append);
            try {
                fos.write(bytes);
                fos.flush();
                if (fos == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }
            fos.close();
        }
        return true;
    }

    public static boolean write(String filePath, String content, String encoding) {
        try {
            return Files.write(filePath, content.getBytes(encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public static boolean writeUTF8(String filePath, String content) {
        return Files.write(filePath, content, "UTF-8");
    }

    public static boolean writeUTF8(File file, String content, boolean append) {
        Asserts.notNull(content, "content");
        return Files.write(file, content.getBytes(_UTF_8_C_), append);
    }

    public static void queryFileList(List<File> fileList, File dir, int type) {
        File[] list;
        File[] fileArray = list = dir.listFiles();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                if (type == 0 || type == 1) {
                    fileList.add(file);
                }
            } else {
                if (type == 0 || type == 2) {
                    fileList.add(file);
                }
                Files.queryFileList(fileList, file, type);
            }
            ++n2;
        }
    }

    public static void queryFilterList(List<File> fileList, File dir, Filter filter) {
        File[] list = dir.listFiles();
        int i = 0;
        while (i < list.length) {
            File file = list[i];
            if (file.isFile()) {
                if (filter.access(file.getName())) {
                    fileList.add(file);
                }
            } else {
                Files.queryFilterList(fileList, file, filter);
            }
            ++i;
        }
    }

    public static void queryEndsWithList(List<File> fileList, File dir, String endsWith) {
        Filter filter = new FilterEndsWith().param(endsWith);
        Files.queryFilterList(fileList, dir, filter);
    }

    public static void queryFilterNameList(List<String> fileNameList, File dir, Filter filter) {
        File[] list = dir.listFiles();
        int i = 0;
        while (i < list.length) {
            File file = list[i];
            if (file.isFile()) {
                if (filter.access(file.getName())) {
                    fileNameList.add(file.getName());
                }
            } else {
                Files.queryFilterNameList(fileNameList, file, filter);
            }
            ++i;
        }
    }

    public static void queryEndsWithNameList(List<String> fileNameList, File dir, String endsWith) {
        Filter filter = new FilterEndsWith().param(endsWith);
        Files.queryFilterNameList(fileNameList, dir, filter);
    }

    public static String getClassName(File classPath, File classFile) {
        try {
            String classPathDir = classPath.getCanonicalPath();
            String classFilePath = classFile.getCanonicalPath();
            return Files.getClassName(classPathDir, classFilePath);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getClassName(String classPath, String classFilePath) {
        String className = Strings.trimLeft(classFilePath, classPath);
        className = Strings.trimRight(className, ".class");
        className = Replaces.replaceAllEscape(className, Systems.getFileSeparator(), ".");
        className = Strings.trimLeft(className, ".");
        return className;
    }

    public static String getPathByCurrentDate() {
        Calendar date = Calendar.getInstance();
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        return String.valueOf(year) + Systems.getFileSeparator() + month + Systems.getFileSeparator() + day;
    }

    public static String getPathByCurrentDate(Date date) {
        Calendar calender = Calendar.getInstance();
        calender.setTime(date);
        int year = calender.get(1);
        int month = calender.get(2) + 1;
        int day = calender.get(5);
        return String.valueOf(year) + Systems.getFileSeparator() + month + Systems.getFileSeparator() + day;
    }

    public static void removeMaxFileAndRenameFile(String fileDir, String fileName, int fileMaxNum, boolean renameCurrentFile) {
        if (fileMaxNum <= 0) {
            return;
        }
        fileDir = Files.toLinuxPath(fileDir);
        fileDir = Strings.removeEndsWith(fileDir, "/");
        HashMap<Integer, File> renameMap = new HashMap<Integer, File>();
        File dir = new File(fileDir);
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String index;
            File file = fileArray[n2];
            if (file.isFile() && file.getName().startsWith(String.valueOf(fileName) + ".") && Validates.isInteger(index = file.getName().substring(fileName.length() + 1))) {
                int ind = Ints.toInt(index);
                if (ind >= fileMaxNum) {
                    file.delete();
                } else {
                    renameMap.put(ind, file);
                }
            }
            ++n2;
        }
        String filePath = String.valueOf(fileDir) + "/" + fileName;
        int i = fileMaxNum - 1;
        while (i >= 1) {
            File file = (File)renameMap.get(i);
            if (file != null) {
                file.renameTo(new File(String.valueOf(filePath) + "." + (i + 1)));
            }
            --i;
        }
        if (renameCurrentFile && Files.exists(filePath)) {
            new File(filePath).renameTo(new File(String.valueOf(filePath) + ".1"));
        }
    }

    public static boolean canExecute(File file) {
        return Systems.isWindows() ? false : file.canExecute();
    }

    public static boolean setExecutable(File file, boolean executable) {
        return Systems.isWindows() ? false : file.setExecutable(executable);
    }

    public static void setHidden(String path, boolean hidden) {
        Files.setHidden(new File(path), hidden);
    }

    public static void setHidden(File file, boolean hidden) {
        if (!Systems.isWindows() || !Files.exists(file)) {
            return;
        }
        try {
            String cmd = "attrib " + (hidden ? "+" : "-") + "H " + "\"" + file.getCanonicalPath() + "\"";
            Windows.cmd(cmd);
        }
        catch (IOException e) {
            throw Asserts.exception(e);
        }
    }
}

