/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.schedule;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.control.ThreadServicer;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Interval;
import org.zhiqim.kernel.schedule.ScheduleFactory;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.kernel.util.seqs.Sequence;

public class Scheduler
extends ThreadServicer
implements SignConstants {
    private static final Log log = LogFactory.getLog(Scheduler.class);
    private ThreadGroup threadGroup;
    private String threadName;
    private Sequence sequence = new Sequence();
    private List<TaskThreader> taskList = new ArrayList<TaskThreader>();
    private List<Interval> intervalList = new ArrayList<Interval>();

    @Override
    protected ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    protected String getThreadName() {
        return this.threadName;
    }

    @Override
    protected boolean openBefore() {
        String name = Strings.toUpperFirstChar(this.id == null ? "Scheduler-" + Randoms.letters(4) : this.id);
        this.threadGroup = new ThreadGroup(String.valueOf(name) + "-Task-");
        this.threadName = name;
        return true;
    }

    @Override
    protected boolean openAfter() {
        if (this.id == null) {
            return true;
        }
        Group grp = Global.getGroup(this.id);
        if (grp == null || grp.isEmpty()) {
            return true;
        }
        log.info((Object)"\u521d\u59cb\u5316[\u5b9a\u65f6\u4efb\u52a1:%s]\u5f00\u59cb...", this.id);
        for (Item item : grp.list()) {
            String value;
            String key = item.getKey();
            Object task = ScheduleFactory.getTaskThreader(key, value = item.getString());
            if (task instanceof TaskThreader) {
                this.addTask((TaskThreader)task);
                continue;
            }
            if (task instanceof Interval) {
                this.addIntervalTask((Interval)task);
                continue;
            }
            log.error((Object)"\u521d\u59cb\u5316[\u5b9a\u65f6\u4efb\u52a1:%s]\u914d\u7f6e\u4e0d\u6b63\u786e[%s][%s]", this.id, key, value);
            return false;
        }
        log.info((Object)"\u521d\u59cb\u5316[\u5b9a\u65f6\u4efb\u52a1:%s]\u5171[%s]\u4e2a\u8ba1\u5212\u4efb\u52a1\u548c[%s]\u4e2a\u8f6e\u5faa\u4efb\u52a1\u5b8c\u6210!!!\r\n", this.id, this.taskList.size(), this.intervalList.size());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAfter() {
        if (this.threadGroup != null) {
            this.threadGroup.destroy();
            this.threadGroup = null;
        }
        if (!this.taskList.isEmpty()) {
            List<TaskThreader> list = this.taskList;
            synchronized (list) {
                for (TaskThreader task : this.taskList) {
                    task.close();
                }
                this.taskList.clear();
            }
        }
        log.info((Object)"\u5b9a\u65f6\u4efb\u52a1[%s]\u76d1\u89c6\u7ebf\u7a0b\u9000\u51fa", this.threadName);
    }

    public int addTask(TaskThreader task) {
        if (this.taskList.contains(task)) {
            return task.getTaskId();
        }
        if (!this.isRunning()) {
            this.open();
        }
        this.taskList.add(task);
        int taskId = this.sequence.nextInt();
        task.setScheduleAndTaskId(this, taskId);
        task.open();
        log.info((Object)"\u589e\u52a0\u8ba1\u5212\u4efb\u52a1[%s]", task.getThreadName());
        return taskId;
    }

    public void removeTask(TaskThreader task) {
        if (this.taskList.remove(task)) {
            task.close();
        }
    }

    public void removeTask(int taskId) {
        TaskThreader qTask = null;
        for (TaskThreader task : this.taskList) {
            if (task.getTaskId() != taskId) continue;
            qTask = task;
            break;
        }
        if (qTask != null) {
            this.removeTask(qTask);
        }
    }

    public void addIntervalTask(Interval interval) {
        this.intervalList.add(interval);
        log.info((Object)"\u589e\u52a0\u95f4\u9694\u4efb\u52a1[%s]", interval.getThreadName());
    }

    public int size() {
        return this.taskList.size();
    }

    public List<TaskThreader> list() {
        return this.taskList;
    }

    public int sizeInterval() {
        return this.intervalList.size();
    }

    public List<Interval> listInterval() {
        return this.intervalList;
    }

    @Override
    protected void first() {
        this.chkMillis();
    }

    @Override
    protected void loop() {
        int[] dts = DateTimes.getCurrent();
        int curYearMonth = dts[8];
        int curMonthMaxDay = dts[9];
        int curDay = dts[2];
        int curHour = dts[3];
        int curMinute = dts[4];
        int curSecond = dts[5];
        int curWeek = dts[7];
        for (TaskThreader task : this.taskList) {
            task.process(curYearMonth, curMonthMaxDay, curDay, curHour, curMinute, curSecond, curWeek);
        }
        int millis = DateTimes.getCurrentMillis();
        Threads.sleepIgnoreException(1000 - millis);
    }

    private void chkMillis() {
        int millis = DateTimes.getCurrentMillis();
        if (millis > 0) {
            Threads.sleepIgnoreException(1000 - millis);
        }
    }

    public Interval interval(Task task, int millis) {
        return Interval.shedule(task, millis);
    }

    public Interval interval(Task task, int firstMillis, int middleMillis) {
        return Interval.shedule(task, firstMillis, middleMillis);
    }

    public Interval interval(Task task, int firstMillis, int middleMillis, int times) {
        return Interval.shedule(task, firstMillis, middleMillis, times);
    }
}

