/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging.logger;

import java.io.File;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.logger.FileLogger;
import org.zhiqim.kernel.util.DateTimes;

public class FileDailyLogger
extends FileLogger {
    private String fileDate;
    private Object lock = new Object();

    @Override
    public void logger(Log log, int level, String message, Throwable throwable) {
        if (level < super.getLevelMin() || level > super.getLevelMax()) {
            return;
        }
        String curDate = DateTimes.getDateString();
        if (!curDate.equals(this.fileDate)) {
            this.convertWriter(curDate);
        }
        this.print(level, message, throwable);
    }

    @Override
    public void setFilePath(String filePath) {
        super.setFilePath(filePath);
        this.convertWriter(DateTimes.getDateString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertWriter(String date) {
        Object object = this.lock;
        synchronized (object) {
            if (date.equals(this.fileDate)) {
                return;
            }
            super.closeWriter();
            super.setFilePathOnly(this.newFilePath(date));
            super.createWriter();
            this.removeMaxFile();
            this.fileDate = date;
        }
    }

    private void removeMaxFile() {
        int fileMaxNum = super.getFileMaxNum();
        if (fileMaxNum <= 0) {
            return;
        }
        String maxIndexDate = DateTimes.getPreviousDateString(fileMaxNum);
        String fileName = super.getFileName();
        String fileDir = super.getFileDir();
        File dir = new File(fileDir);
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String date;
            File file = fileArray[n2];
            if (file.isFile() && file.getName().length() >= 10 && file.getName().endsWith("." + fileName) && (date = file.getName().substring(0, 10)).compareTo(maxIndexDate) < 0) {
                file.delete();
            }
            ++n2;
        }
    }

    private String newFilePath(String date) {
        return String.valueOf(this.fileDir) + "/" + date + "." + this.fileName;
    }
}

