/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging;

import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogConstants;
import org.zhiqim.kernel.logging.LogServerDefault;
import org.zhiqim.kernel.logging.LogService;
import org.zhiqim.kernel.util.DateTimes;

public final class LogFactory
implements SignConstants,
LogConstants {
    private static final Object lock = new Object();
    private static final HashMapCV<Log> classMap = new HashMapCV();
    private static final HashMapSV<Log> nameMap = new HashMapSV();
    private static LogService logServer;

    public static final int getLevel(String levelInfo) {
        if ("DEBUG".equalsIgnoreCase(levelInfo)) {
            return 1;
        }
        if ("INFO".equalsIgnoreCase(levelInfo)) {
            return 2;
        }
        if ("ERROR".equalsIgnoreCase(levelInfo)) {
            return 3;
        }
        if ("WARN".equalsIgnoreCase(levelInfo)) {
            return 4;
        }
        if ("FATAL".equalsIgnoreCase(levelInfo)) {
            return 5;
        }
        return 0;
    }

    public static final String getLevel(int level) {
        switch (level) {
            case 1: {
                return "DEBUG";
            }
            case 2: {
                return "INFO";
            }
            case 3: {
                return "ERROR";
            }
            case 4: {
                return "WARN";
            }
            case 5: {
                return "FATAL";
            }
        }
        return "UNDNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Log getLog(Class<?> clazz) {
        Log log = (Log)classMap.get(clazz);
        if (log != null) {
            return log;
        }
        Object object = lock;
        synchronized (object) {
            if (logServer == null) {
                logServer = new LogServerDefault();
            }
            log = new Log(clazz, logServer);
            classMap.put(clazz, log);
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Log getLog(String name) {
        Log log = (Log)nameMap.get(name);
        if (log != null) {
            return log;
        }
        Object object = lock;
        synchronized (object) {
            if (logServer == null) {
                logServer = new LogServerDefault();
            }
            log = new Log(name, logServer);
            nameMap.put(name, log);
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updateLogService(LogService logService) {
        Object object = lock;
        synchronized (object) {
            logServer = logService;
            for (Log log : classMap.values()) {
                log.setLogService(logServer);
            }
            for (Log log : nameMap.values()) {
                log.setLogService(logServer);
            }
        }
    }

    public static final String format(String pattern, String message, String level) {
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c != '%' || i == pattern.length() - 1) {
                strb.append(c);
            } else {
                char c2 = pattern.charAt(i + 1);
                switch (c2) {
                    case 'm': {
                        strb.append(message);
                        ++i;
                        break;
                    }
                    case 'd': {
                        strb.append(DateTimes.getDateTimeSSSString());
                        ++i;
                        break;
                    }
                    case 'l': {
                        strb.append(level);
                        ++i;
                        break;
                    }
                    case 't': {
                        strb.append(Thread.currentThread().getName());
                        ++i;
                        break;
                    }
                    case 'n': {
                        strb.append("\r\n");
                        ++i;
                        break;
                    }
                    default: {
                        strb.append(c);
                    }
                }
            }
            ++i;
        }
        return strb.toString();
    }
}

