/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.extend;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Asserts;

@AnAlias(value={"LinkedMapSO"})
@AnNew
public class LinkedMapSO
extends HashMapSO {
    public LinkedMapSO() {
        this.instance = new LinkedHashMap();
    }

    public LinkedMapSO(int count) {
        this.instance = new LinkedHashMap(count);
    }

    public LinkedMapSO(int initialCapacity, float loadFactor, boolean accessOrder) {
        this.instance = new LinkedHashMap(initialCapacity, loadFactor, accessOrder);
    }

    public LinkedMapSO(String key, Object value) {
        this.instance = new LinkedHashMap(1);
        this.instance.put(key, value);
    }

    public LinkedMapSO(Map<String, Object> instance) {
        this.instance = new LinkedHashMap<String, Object>(instance);
    }

    public LinkedMapSO(MapSO instance) {
        this.instance = new LinkedHashMap<String, Object>(instance.instance());
    }

    public Object[] toArray() {
        return this.instance.values().toArray();
    }

    public Object get(int index) {
        Asserts.asserts(index >= 0, ZhiqimI18n.indexMustBeGreaterThanOrEqualZero);
        if (index >= this.instance.size()) {
            return null;
        }
        Set entrySet = this.instance.entrySet();
        Iterator it = entrySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (index <= i) {
                if (index != i) break;
                return entry.getValue();
            }
            ++i;
        }
        return null;
    }

    @Override
    public int size() {
        return this.instance.size();
    }

    @Override
    public boolean isEmpty() {
        return this.instance.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.instance.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.instance.containsValue(value);
    }

    @Override
    public Object get(String key) {
        return this.instance.get(key);
    }

    @Override
    public LinkedMapSO put(String key, Object value) {
        this.instance.put(key, value);
        return this;
    }

    @Override
    public LinkedMapSO remove(String key) {
        this.instance.remove(key);
        return this;
    }

    @Override
    public LinkedMapSO putAll(Map<String, Object> m) {
        this.instance.putAll(m);
        return this;
    }

    @Override
    public LinkedMapSO clear() {
        this.instance.clear();
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.instance.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.instance.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.instance.entrySet();
    }

    @Override
    public String toString() {
        return this.instance.toString();
    }
}

