/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.control.Queue;
import org.zhiqim.kernel.control.ThreadServicer;
import org.zhiqim.kernel.control.Threader;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Threads;

public class ThreaderController
extends ThreadServicer {
    private static final Log log = LogFactory.getLog(ThreaderController.class);
    private int poMinSize;
    private int poMaxSize;
    private int poIdleTimeMs;
    private int poQueueSize;
    private ThreadGroup threadGroup;
    private String threadName = "Threader-" + Randoms.upperLetters(1) + Randoms.lowerLettersDigits(3);
    private final ArrayList<Threader> theaderList = new ArrayList();
    private final Queue<Runnable> queue = new Queue();
    private final AtomicLong completedCount = new AtomicLong();

    public ThreaderController set(int poMinSize, int poMaxSize, int poIdleTime, int poQueueSize) {
        this.poMinSize = poMinSize < 1 ? 1 : poMinSize;
        this.poMaxSize = poMaxSize < poMinSize ? poMinSize : poMaxSize;
        this.poIdleTimeMs = (poIdleTime < 180 ? 180 : poIdleTime) * 1000;
        this.poQueueSize = poQueueSize < this.poMaxSize * 3 ? this.poMaxSize * 3 : poQueueSize;
        return this;
    }

    public void setThreadName(String threadName) {
        this.threadName = Strings.toUpperFirstChar(threadName);
    }

    @Override
    protected ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    protected String getThreadName() {
        return String.valueOf(this.threadName) + "-Controller";
    }

    @Override
    public boolean openBefore() {
        if (this.id == null) {
            Asserts.as((String)(this.poMaxSize >= this.poMinSize && this.poMinSize > 0 && this.poIdleTimeMs > 0 && this.poQueueSize > 0 ? null : "\u7ebf\u7a0b\u6c60\u670d\u52a1\u914d\u7f6e\u53c2\u6570\u4e0d\u6b63\u786e"));
        } else {
            Group grp = Global.getGroup(this.id);
            if (grp == null) {
                log.error((Object)"\u7ebf\u7a0b\u6c60\u670d\u52a1[%s]\u672a\u914d\u7f6e\u53c2\u6570", this.id);
                return false;
            }
            this.threadName = Strings.toUpperFirstChar(this.id);
            this.set(grp.getInt("poMinSize"), grp.getInt("poMaxSize"), grp.getInt("poIdleTime"), grp.getInt("poQueueSize"));
        }
        this.threadGroup = new ThreadGroup(this.threadName);
        int i = 0;
        while (i < this.poMinSize) {
            this.openThreader();
            ++i;
        }
        return true;
    }

    @Override
    public void closeAfter() {
        this.closeThreaders();
        log.info((Object)"\u7ebf\u7a0b\u6c60[%s]\u76d1\u89c6\u7ebf\u7a0b\u9000\u51fa", this.threadName);
    }

    @Override
    public void loop() {
        if (this.theaderList.size() > this.poMinSize) {
            this.chkThreaders();
        }
        Threads.sleepIgnoreException(this.poIdleTimeMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openThreader() {
        ArrayList<Threader> arrayList = this.theaderList;
        synchronized (arrayList) {
            Threader threader = new Threader(this);
            threader.open();
            this.theaderList.add(threader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeThreaders() {
        ArrayList<Threader> arrayList = this.theaderList;
        synchronized (arrayList) {
            for (Threader threader : this.theaderList) {
                threader.close();
                Object var2_3 = null;
            }
            this.theaderList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chkThreaders() {
        ArrayList<Threader> arrayList = this.theaderList;
        synchronized (arrayList) {
            Iterator<Threader> it = this.theaderList.iterator();
            while (it.hasNext()) {
                if (this.theaderList.size() <= this.poMinSize) break;
                Threader threader = it.next();
                if (!threader.isExecessMaxIdleTime(this.poIdleTimeMs)) continue;
                it.remove();
                threader.close();
            }
        }
    }

    public boolean execute(Runnable command) {
        return this.execute(command, false);
    }

    public synchronized boolean execute(Runnable command, boolean priority) {
        if (!this.isRunning() || command == null) {
            return false;
        }
        int threaderSize = this.theaderList.size();
        int activeSize = this.getThreaderActiveSize();
        if (activeSize < threaderSize) {
            this.queue.post(command, priority);
            return true;
        }
        if (threaderSize < this.poMaxSize) {
            this.openThreader();
            this.queue.post(command, priority);
            return true;
        }
        if (this.queue.size() < this.poMaxSize) {
            this.queue.post(command, priority);
            return true;
        }
        if (this.queue.size() < this.poQueueSize) {
            this.queue.post(command, priority);
            return true;
        }
        log.fatal((Object)"\u7ebf\u7a0b\u6c60[%s]\u7e41\u5fd9\u8d85\u9650\uff0c\u4e8b\u4ef6\u5bf9\u961f\u5df2\u6ee1\uff0c\u65e0\u6cd5\u63a5\u6536\u5904\u7406", this.threadName);
        return false;
    }

    Runnable accept() {
        return this.queue.accept(5000);
    }

    void addCompletedCount() {
        this.completedCount.incrementAndGet();
    }

    public void clear() {
        this.queue.clear();
    }

    public boolean contains(Runnable command) {
        return this.queue.contains(command);
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Queue<Runnable> getQueue() {
        return this.queue;
    }

    public long getCompletedCount() {
        return this.completedCount.get();
    }

    public List<Threader> getThreaderList() {
        return Collections.unmodifiableList(this.theaderList);
    }

    public int getThreaderSize() {
        return this.theaderList.size();
    }

    public int getThreaderActiveSize() {
        int count = 0;
        for (Threader threader : this.theaderList) {
            if (!threader.isActive()) continue;
            ++count;
        }
        return count;
    }

    public int getPoMinSize() {
        return this.poMinSize;
    }

    public int getPoMaxSize() {
        return this.poMaxSize;
    }

    public int getPoIdleTime() {
        return this.poIdleTimeMs / 1000;
    }

    public int getPoQueueSize() {
        return this.poQueueSize;
    }
}

