/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.exception;

import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Statement;

/**
 * 定义语句解析异常，可以得到出错的路径、行列号
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class StatementException extends Exception
{
    private static final long serialVersionUID = 1L;
    
    private String path;
    private int lineNo;
    private int columnNo;
    
    public StatementException(Statement s, String message)
    {
        this(s.getPath(), s.getBeginLine(), s.getBeginColumn(), message);
    }
    
    public StatementException(Statement s, String message, Throwable exception)
    {
        this(s.getPath(), s.getBeginLine(), s.getBeginColumn(), message, exception);
    }
    
    public StatementException(String path, int lineNo, int columnNo, String message)
    {
        super(new StringBuilder("[").append(Validates.isEmptyBlank(path)?"自定义ZML":path).append("]").append("[第").append(lineNo).append("行],[第").append(columnNo).append("列][").append(message).append("]").toString());
        
        this.path = path;
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }
    
    public StatementException(String path, int lineNo, int columnNo, String message, Throwable exception)
    {
        super(new StringBuilder("[").append(Validates.isEmptyBlank(path)?"自定义ZML":path).append("]").append("[第").append(lineNo).append("行],[第").append(columnNo).append("列][").append(message).append("]").toString(), exception);
        
        this.path = path;
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }
    
    /************************************************/
    //异常时获取文件对应的路径、行号和列号
    /************************************************/

    public String getPath()
    {
        return path;
    }

    public int getLineNo()
    {
        return lineNo;
    }

    public int getColumnNo()
    {
        return columnNo;
    }
}
