/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.xml.parser;

import java.util.Map;
import java.util.Map.Entry;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.xml.Xml;
import org.zhiqim.kernel.xml.XmlParser;
import org.zhiqim.kernel.xml.Xmls;

/**
 * 哈唏表解析器，和对象解析器类似
 *
 * @version v1.1.2 @author zouzhigang 2015-8-21 新建与整理
 */
public class MapParser implements XmlParser, SignConstants
{
    private Xml xmlMain;
    
    @Override
    public XmlParser set(Xml xmlMain)
    {
        this.xmlMain = xmlMain;
        return this;
    }
    
    @Override
    public String toStringInner(Object obj, String tagName, int tagLevel)
    {
        if (tagName == null)
            tagName = "xml";
        
        StringBuilder strb = new StringBuilder();
        Strings.addNewLine(strb);
        Strings.addTwoSpace(strb, tagLevel);
        Xmls.addTagBegin(strb, tagName);
        
        Map<?, ?> map = (Map<?, ?>)obj;
        for (Entry<?, ?> entry : map.entrySet())
        {
            String tag = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            strb.append(xmlMain.toStringInner(value, tag, tagLevel+1));
        }
        
        Strings.addNewLine(strb);
        Strings.addTwoSpace(strb, tagLevel);
        Xmls.addTagEnd(strb, tagName);
        return strb.toString();
    }

    @Override
    public Object toObjectInner(Node node, Class<?> clazz, Class<?> generics)
    {
        Map<String, Object> map = Classes.newMap(clazz);
        if (map == null)
        {//不支持的类型
            return null;
        }
        
        if (node == null || generics == null)
        {//没有内容或没配置泛型返回空表
            return map;
        }
        
        NodeList childList = node.getChildNodes();
        for (int i=0;i<childList.getLength();i++)
        {
            Node child = childList.item(i);
            if (child.getNodeType() != Node.ELEMENT_NODE)
                continue;
            
            String key = child.getNodeName();
            map.put(key, xmlMain.toObjectInner(child, generics, null));
        }
        
        return map;
    }
}
