/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Types;

/**
 * Xml定义类
 *
 * @version v1.1.2 @author zouzhigang 2015-8-21 新建与整理
 */
public class Xml implements SignConstants, CodeConstants
{
    public static final Xml xml = new Xml();
    
    private boolean versionFlag = true;//默认输出<?xml version="1.0" encoding="UTF-8"?>
    private String version = "1.0";
    private String encoding = "UTF-8";
    private boolean format = true;
    
    private XmlFactory factory;
    
    public Xml()
    {
        factory = new XmlFactory(this);
    }
    
    public String getXmlVersionTag()
    {
        return new StringBuilder("<?xml version=\"").append(version).append("\" encoding=\"").append(encoding).append("\"?>").toString();
    }
    
    /**
     * 对象转换成XML字符串
     * 
     * @param obj   对象
     * @return      JSON字符串
     */
    public String toString(Object obj)
    {
        if (obj == null)
        {//XML不支持null，统一返回空字符串
            return _EMPTY_;
        }
        
        if (Types.isSingle(obj))
        {//单一类型，返回String.valueOf
            return String.valueOf(obj);
        }
        
        StringBuilder strb = new StringBuilder();
        if (versionFlag)
        {//要求版本标志并且不是单一类型时有效
            strb.append(getXmlVersionTag());
        }
        
        String tagName = null;
        if (obj instanceof XmlTag)
        {//如果对象实现XmlTag接口则读出来
            tagName = ((XmlTag)obj).getXmlTag();
        }
        
        //到解释工厂中找到解释器解释
        strb.append(toStringInner(obj, tagName, 0));
        return strb.toString();
    }
    
    /** 从解释工厂中找到解释器解释 */
    public String toStringInner(Object obj, String tagName, int tagLevel)
    {
        return (factory.getParser(obj.getClass())).toStringInner(obj, tagName, tagLevel);
    }
    
    /**
     * XML字符串转换成对象
     * 
     * @param json  JSON字符串
     * @param clazz 转换成对象的类
     * @return      obj对象
     */
    public <T> T toObject(String xml, Class<T> clazz)
    {
        Asserts.as(xml != null?null:"XML转对象时，XML不允许为null");
        
        try
        {
            Document doc = Xmls.buildDocument(xml, _UTF_8_);
            Node node = doc.getFirstChild();
            return toObjectInner(node, clazz, null);
        }
        catch (Exception e)
        {
            throw Asserts.exception("XML转对象时，XML格式不正确:"+e.getMessage());
        }
    }
    
    /**
     * XML字符串转换成对象
     * 
     * @param node  XML节点
     * @param clazz 转换成对象的类
     * @return      obj对象
     */
    @SuppressWarnings("unchecked")
    public <T> T toObjectInner(Node node, Class<T> clazz, Class<?> generics)
    {
        return (T)factory.getParser(clazz).toObjectInner(node, clazz, generics);
    }
    
    public boolean isFormat()
    {
        return format;
    }
}
