/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

/**
 * 摘要输入流，写出流的同时，更新摘要信息
 *
 * @version v1.0.0 @author zouzhigang 2017-4-11 新建与整理
 */
public class DigestInputStream extends FilterInputStream
{
    private MessageDigest digest;
    private long length;

    public DigestInputStream(InputStream stream, MessageDigest digest)
    {
        super(stream);
        this.digest = digest;
    }
    
    /**************************************************************************/
    //读出流，同时更新摘要和数目
    /**************************************************************************/

    public int read() throws IOException
    {
        int ch = in.read();
        if (ch != -1)
        {
            digest.update((byte) ch);
            length++;
        }
        
        return ch;
    }
    
    public int read(byte[] b) throws IOException
    {
        int result = in.read(b);
        if (result != -1)
        {
            digest.update(b, 0, result);
            length += result;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException
    {
        int result = in.read(b, off, len);
        if (result != -1)
        {
            digest.update(b, off, result);
            length += len;
        }
        return result;
    }

    /**************************************************************************/
    //获取最终摘要和数目
    /**************************************************************************/
    
    public MessageDigest getMessageDigest()
    {
        return digest;
    }
    
    public byte[] digest()
    {
        return digest.digest();
    }
    
    public long length()
    {
        return length;
    }
    
    public String toString()
    {
        return "[DigestInputStream] " + digest.toString();
    }
}